% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{lexmodelbuildingservice}
\alias{lexmodelbuildingservice}
\title{Amazon Lex Model Building Service}
\usage{
lexmodelbuildingservice(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Lex Build-Time Actions

Amazon Lex is an AWS service for building conversational voice and text
interfaces. Use these actions to create, update, and delete
conversational bots for new and existing client applications.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- lexmodelbuildingservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:lexmodelbuildingservice_create_bot_version]{create_bot_version} \tab Creates a new version of the bot based on the $LATEST version\cr
\link[paws.machine.learning:lexmodelbuildingservice_create_intent_version]{create_intent_version} \tab Creates a new version of an intent based on the $LATEST version of the intent\cr
\link[paws.machine.learning:lexmodelbuildingservice_create_slot_type_version]{create_slot_type_version} \tab Creates a new version of a slot type based on the $LATEST version of the specified slot type\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_bot]{delete_bot} \tab Deletes all versions of the bot, including the $LATEST version\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_bot_alias]{delete_bot_alias} \tab Deletes an alias for the specified bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_bot_channel_association]{delete_bot_channel_association} \tab Deletes the association between an Amazon Lex bot and a messaging platform\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_bot_version]{delete_bot_version} \tab Deletes a specific version of a bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_intent]{delete_intent} \tab Deletes all versions of the intent, including the $LATEST version\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_intent_version]{delete_intent_version} \tab Deletes a specific version of an intent\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_slot_type]{delete_slot_type} \tab Deletes all versions of the slot type, including the $LATEST version\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_slot_type_version]{delete_slot_type_version} \tab Deletes a specific version of a slot type\cr
\link[paws.machine.learning:lexmodelbuildingservice_delete_utterances]{delete_utterances} \tab Deletes stored utterances\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bot]{get_bot} \tab Returns metadata information for a specific bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bot_alias]{get_bot_alias} \tab Returns information about an Amazon Lex bot alias\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bot_aliases]{get_bot_aliases} \tab Returns a list of aliases for a specified Amazon Lex bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bot_channel_association]{get_bot_channel_association} \tab Returns information about the association between an Amazon Lex bot and a messaging platform\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bot_channel_associations]{get_bot_channel_associations} \tab Returns a list of all of the channels associated with the specified bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bots]{get_bots} \tab Returns bot information as follows:\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_bot_versions]{get_bot_versions} \tab Gets information about all of the versions of a bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_builtin_intent]{get_builtin_intent} \tab Returns information about a built-in intent\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_builtin_intents]{get_builtin_intents} \tab Gets a list of built-in intents that meet the specified criteria\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_builtin_slot_types]{get_builtin_slot_types} \tab Gets a list of built-in slot types that meet the specified criteria\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_export]{get_export} \tab Exports the contents of a Amazon Lex resource in a specified format\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_import]{get_import} \tab Gets information about an import job started with the StartImport operation\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_intent]{get_intent} \tab Returns information about an intent\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_intents]{get_intents} \tab Returns intent information as follows:\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_intent_versions]{get_intent_versions} \tab Gets information about all of the versions of an intent\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_migration]{get_migration} \tab Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an Amazon Lex V2 bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_migrations]{get_migrations} \tab Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_slot_type]{get_slot_type} \tab Returns information about a specific version of a slot type\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_slot_types]{get_slot_types} \tab Returns slot type information as follows:\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_slot_type_versions]{get_slot_type_versions} \tab Gets information about all versions of a slot type\cr
\link[paws.machine.learning:lexmodelbuildingservice_get_utterances_view]{get_utterances_view} \tab Use the GetUtterancesView operation to get information about the utterances that your users have made to your bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags associated with the specified resource\cr
\link[paws.machine.learning:lexmodelbuildingservice_put_bot]{put_bot} \tab Creates an Amazon Lex conversational bot or replaces an existing bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_put_bot_alias]{put_bot_alias} \tab Creates an alias for the specified version of the bot or replaces an alias for the specified bot\cr
\link[paws.machine.learning:lexmodelbuildingservice_put_intent]{put_intent} \tab Creates an intent or replaces an existing intent\cr
\link[paws.machine.learning:lexmodelbuildingservice_put_slot_type]{put_slot_type} \tab Creates a custom slot type or replaces an existing custom slot type\cr
\link[paws.machine.learning:lexmodelbuildingservice_start_import]{start_import} \tab Starts a job to import a resource to Amazon Lex\cr
\link[paws.machine.learning:lexmodelbuildingservice_start_migration]{start_migration} \tab Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2\cr
\link[paws.machine.learning:lexmodelbuildingservice_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource\cr
\link[paws.machine.learning:lexmodelbuildingservice_untag_resource]{untag_resource} \tab Removes tags from a bot, bot alias or bot channel
}
}

\examples{
\dontrun{
svc <- lexmodelbuildingservice()
# This example shows how to get configuration information for a bot.
svc$get_bot(
  name = "DocOrderPizza",
  versionOrAlias = "$LATEST"
)
}

}
