% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{parDistributionCustom}
\alias{parDistributionCustom}
\alias{parDistributionFor}
\title{Produce data suitable for plotting parameter distributions}
\usage{
parDistributionCustom(fit, pars, nameVec, label = withoutIndex(pars[1]),
  samples = 500)

parDistributionFor(fit, pi, samples = 500)
}
\arguments{
\item{fit}{a \code{\link[rstan:stanfit-class]{stanfit}} object}

\item{pars}{a vector of parameter names}

\item{nameVec}{a vector of explanatory parameters names}

\item{label}{column name for \code{nameVec}}

\item{samples}{number of posterior samples}

\item{pi}{a data.frame returned by \code{\link{parInterval}}}
}
\value{
A data.frame with the following columns:
\describe{
\item{sample}{Sample index}
\item{\emph{label}}{A name from \emph{nameVec}}
\item{value}{A single sample of the associated parameter}
}
}
\description{
Produce data suitable for plotting parameter distributions
}
\examples{
\donttest{ vignette('manual', 'pcFactorStan') }
}
\seealso{
Other data extractor: \code{\link{parInterval}},
  \code{\link{responseCurve}}
}
\concept{data extractor}
