% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{prepData}
\alias{prepData}
\title{Transforms data into a form tailored for efficient evaluation by Stan}
\usage{
prepData(df)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}
}
\value{
a data list suitable for passing as the \code{data}
  argument to \code{\link{pcStan}} or \code{\link[rstan]{stan}}
}
\description{
Invokes \code{\link{filterGraph}} and \code{\link{normalizeData}}.
Vertex names, if not already factors, are converted to
factors.  The number of thresholds per item is determined by the
largest absolute response value.  Missing responses are filtered
out.  Responses on the same pair of vertices on the same item are
grouped together.  Within a vertex pair and item, responses
are ordered from negative to positive.
}
\examples{
df <- prepData(phyActFlowPropensity)
str(df)

}
\seealso{
Other data preppers: \code{\link{prepCleanData}}
}
\concept{data preppers}
