% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{prepCleanData}
\alias{prepCleanData}
\title{Transforms data into a form tailored for efficient evaluation by Stan}
\usage{
prepCleanData(df)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}
}
\value{
a data list suitable for passing as the \code{data}
  argument to \code{\link{pcStan}} or \code{\link[rstan]{stan}}
}
\description{
Vertex names, if not already factors, are converted to
factors.  The number of thresholds per item is determined by the
largest absolute response value.  Missing responses are filtered
out.  Responses on the same pair of vertices on the same item are
grouped together.  Within a vertex pair and item, responses
are ordered from negative to positive.
}
\details{
Note: Reordering of responses is likely unless something like
\code{\link{normalizeData}} has been used with \code{.sortRows=TRUE}.
}
\examples{
df <- prepCleanData(phyActFlowPropensity)
str(df)
}
\seealso{
Other data preppers: 
\code{\link{prepData}()},
\code{\link{prepFactorModel}()},
\code{\link{prepSingleFactorModel}()}
}
\concept{data preppers}
