% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsCSend1D}
\alias{NumArcsCSend1D}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) - end interval case}
\usage{
NumArcsCSend1D(dat, t, int)
}
\arguments{
\item{dat}{A vector of 1D points which constitute the vertices of the digraph}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region}

\item{int}{A vector of two real numbers representing an interval}
}
\value{
Number of arcs for the CS-PCD with vertices being 1D data set, \code{dat},
expansion parameter, \code{t}, for the end intervals.
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) whose
vertices are a 1D numerical data set, \code{dat}, outside the interval \eqn{int=(a,b)}.

CS proximity region is constructed only with expansion parameter \eqn{t>0} for points outside the interval \eqn{(a,b)}.

End vertex regions are based on the end points of the interval,
i.e., the corresponding end vertex region is an interval as \eqn{(-\infty,a)} or \eqn{(b,\infty)} for the interval \eqn{(a,b)}.
For the number of arcs, loops are not allowed, so arcs are only possible for points outside
the interval, \code{int}, for this function.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)

n<-5
datL<-runif(n,a-5,a)
datR<-runif(n,b,b+5)
dat<-c(datL,datR)

NumArcsCSend1D(dat,t=2,int)

NumArcsCSend1D(dat,t=1.2,int)

NumArcsCSend1D(dat,t=4,int)

NumArcsCSend1D(dat,t=2,int+5)
NumArcsCSend1D(dat,t=2,int=c(-5,15))

n<-10  #try also n<-20
dat2<-runif(n,a-5,b+5)
NumArcsCSend1D(dat2,t=2,int)

t<-.5
NumArcsCSend1D(dat,t,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSmid1D}}, \code{\link{NumArcsPEmid1D}}, and \code{\link{NumArcsPEend1D}}
}
