% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{cp2edges.nd}
\alias{cp2edges.nd}
\title{Projections of Centers for non-degenerate asymptotic distribution of domination number of
Proportional Edge Proximity Catch Digraphs (PE-PCDs) to its edges}
\usage{
cp2edges.nd(tri, r, cent = 1)
}
\arguments{
\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} for this function}

\item{cent}{Index of the center (as 1,2,3 corresponding to M1,M2,M3) which gives nondegenerate asymptotic
distribution of the domination number of PE-PCD for uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]};
default \code{cent}=1}
}
\value{
Three projection points (stacked row-wise) from one of the centers (as 1,2,3 corresponding to
M1,M2,M3) which gives nondegenerate asymptotic distribution of the domination number of PE-PCD for
uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]}.
}
\description{
Returns the projections from  center \code{cent} to the edges on the extension of the lines joining \code{cent} to the vertices
in the triangle, \code{tri}. Here M is one of the three centers which gives nondegenerate asymptotic distribution
of the domination number of PE-PCD for uniform data in \code{tri} for a given expansion parameter \code{r} in \eqn{(1,1.5]}.
The center label \code{cent} values 1,2,3 correspond to the vertices \eqn{M_1}, \eqn{M_2}, and \eqn{M_3} (i.e., row numbers in the
output of cent.nondeg(tri,r)); default for \code{cent} is 1. \code{cent} becomes center of mass CM for \eqn{r=1.5}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
r<-1.35

cp2edges.nd(Tr,r,cent=2)

Ms<-cent.nondeg(Tr,r)

Ds<-cp2edges.nd(Tr,r,cent=1)
D1<-Ds[1,]; D2<-Ds[2,]; D3<-Ds[3,]

Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Ms,pch=".",col=1)
polygon(Ms,lty=2)

xc<-Tr[,1]
yc<-Tr[,2]
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-Ms
xc<-txt[,1]
yc<-txt[,2]
txt.str<-c("M1","M2","M3")
text(xc,yc,txt.str)

points(Ds,pch=4,col=2)
L<-Tr; R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2,col=2)
txt<-Ds
xc<-txt[,1]
yc<-txt[,2]
txt.str<-c("D1","D2","D3")
text(xc,yc,txt.str)

cp2edges.nd(Tr,r,1)

dat.fr<-data.frame(a=Tr)
cp2edges.nd(dat.fr,r,1)

\dontrun{
cp2edges.nd(Tr,r,cent=5)
#gives an error message since center index, cent, must be 1, 2 or 3
cp2edges.nd(Tr,r=2,cent=2)
#gives an error message since r must be a scalar in (1,1.5]

T2<-rbind(A,A+2*(C-A),C)
cp2edges.nd(T2,r,cent=2)
#gives an error message since the triangle is degenerate
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cp2e.bastri}} and \code{\link{cp2e.tri}}
}
