% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotPEarcsMT}
\alias{plotPEarcsMT}
\title{The plot of the arcs of Proportional Edge Proximity Catch Digraph (PE-PCD) for a
2D data set - multiple triangle case}
\usage{
plotPEarcsMT(
  Xp,
  Yp,
  r,
  M = c(1, 1, 1),
  asp = NA,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{M}{A 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle (for this argument should be set as \code{M}="CC"),
default for \eqn{M=(1,1,1)} which is the center of mass of each triangle}

\item{asp}{a numeric value, giving the aspect ratio y/x (default is \code{NA}), see the official help for \code{asp} by typing "? asp"}

\item{main}{An overall title for the plot (default="")}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both)}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges (default=\code{NULL} for both)}

\item{\dots}{Additional \code{plot} parameters}
}
\value{
A plot of the arcs of the PE-PCD whose vertices are the points in data set \code{Xp} and the Delaunay
triangles based on \code{Yp} points
}
\description{
Plots the arcs of Proportional Edge Proximity Catch Digraph (PE-PCD) whose vertices are the data
points in \code{Xp} in the multiple triangle case and the Delauany triangles based on \code{Yp} points.

PE proximity regions are defined with respect to the Delaunay triangles based on \code{Yp} points with
expansion parameter \eqn{r \ge 1} and vertex regions in each triangle are based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of each Delaunay triangle or based on circumcenter of
each Delaunay triangle (default for \eqn{M=(1,1,1)} which is the center of mass of the triangle).
Each Delaunay triangle is first converted to an (unscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle (this conversion is not necessary when \code{M} is CM).

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes the
convex hull of \code{Yp} points). Loops are not allowed so arcs are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}) for more
on the PE-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

r<-1.5  #try also r<-2

Xlim<-range(Xp[,1],Yp[,1])
Ylim<-range(Xp[,2],Yp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plotPEarcsMT(Xp,Yp,r,M,xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))

plotPEarcsMT(Xp,Yp[1:3,],r,M,xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEarcsTri}}, \code{\link{plotASarcsMT}}, and \code{\link{plotCSarcsMT}}
}
