% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{radii}
\alias{radii}
\title{The radii of points from one class with respect to points from the other class}
\usage{
radii(x, y)
}
\arguments{
\item{x}{A set of d-dimensional points for which the radii are computed. Radius of an \code{x} point equals to the
distance to the closest \code{y} point}

\item{y}{A set of d-dimensional points representing the reference points for the balls. That is, radius
of an \code{x} point is defined as the minimum distance to the \code{y} points.}
}
\value{
A list with three elements
\item{rad}{A vector whose entries are the radius values for the \code{x} points. Radius of an \code{x} point equals to
the distance to the closest \code{y} point}
\item{index.of.clYp}{A vector of indices of the closest \code{y} points to the \code{x} points. The i-th entry in this
vector is the index of the closest \code{y} point to i-th \code{x} point.}
\item{closest.Yp}{A vector of the closest \code{y} points to the \code{x} points. The i-th entry in this
vector or i-th row in the matrix is the closest \code{y} point to i-th \code{x} point.}
}
\description{
Returns the radii of the balls centered at \code{x} points where radius of an \code{x} point equals to the minimum distance
to \code{y} points (i.e. distance to the closest \code{y} point). That is, for each \code{x} point \eqn{radius= \min_{y \in Y}(d(x,y))}.
\code{x} and \code{y} points must be of the same dimension.
}
\examples{
nx<-10
ny<-5
X<-cbind(runif(nx),runif(nx))
Y<-cbind(runif(ny),runif(ny))
Rad<-radii(X,Y)
Rad
rd<-Rad$rad

Xlim<-range(X[,1]-rd,X[,1]+rd,Y[,1])
Ylim<-range(X[,2]-rd,X[,2]+rd,Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(rbind(Y),asp=1,pch=16,col=2,xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(rbind(X))
interp::circles(X[,1],X[,2],Rad$rad,lty=1,lwd=1,col=4)

nx<-5
ny<-1
X<-cbind(runif(nx),runif(nx))
Y<-matrix(c(runif(ny),runif(ny)),ncol=2)
Rad<-radii(X,Y)
Rad
radii(Y,X)

rd<-Rad$rad

Xlim<-range(X[,1]-rd,X[,1]+rd,Y[,1])
Ylim<-range(X[,2]-rd,X[,2]+rd,Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(rbind(Y),asp=1,pch=16,col=2,xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(rbind(X))
interp::circles(X[,1],X[,2],Rad$rad,lty=1,lwd=1,col=4)

radii(c(1,2),c(2,3))

\dontrun{
nx<-10
ny<-5
X<-runif(nx)
Y<-runif(ny)
radii(X,Y)  #this does not work, as X and Y are treated as vectors (i.e. points)
}

nx<-10
ny<-5
X<-as.matrix(X)
Y<-as.matrix(Y)
radii(X,Y)  #this works as X and Y are treated as 1D data sets

nx<-10
ny<-5
X<-cbind(runif(nx),runif(nx),runif(nx))
Y<-cbind(runif(ny),runif(ny),runif(ny))
radii(X,Y)

dat.fr<-data.frame(a=X)
radii(dat.fr,Y)
radii(Y,dat.fr)

}
\seealso{
\code{\link{radius}}
}
