% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{ArcsPEend1D}
\alias{ArcsPEend1D}
\title{The arcs of Proportional Edge Proximity Catch Digraph (PE-PCD) for 1D data - end interval case}
\usage{
ArcsPEend1D(Xp, Yp, r)
}
\arguments{
\item{Xp}{A set or vector of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set or vector of 1D points which constitute the end points of the intervals.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}
}
\value{
A list with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, it is the expansion parameter.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the intervalization based on \code{Yp}.}
\item{tess.name}{Name of data set used in tessellation, it is \code{Yp} for this function}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set which constitutes the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of PE-PCD for 1D data in the end intervals}
\item{E}{Heads (or arrow ends) of the arcs of PE-PCD for 1D data in the end intervals}
\item{mtitle}{Text for "main" title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals (which is 2 for end intervals), number of arcs, and arc density.}
}
\description{
An object of class "PCDs".
Returns arcs as tails (or sources) and heads (or arrow ends) for 1D data set \code{Xp} as the vertices
of PE-PCD.  \code{Yp} determines the end points of the end intervals.

For this function, PE proximity regions are constructed data points outside the intervals based on
\code{Yp} points with expansion parameter \eqn{r \ge 1}. That is, for this function,
arcs may exist for points only inside end intervals.
It also provides various descriptions and quantities about the arcs of the PE-PCD
such as number of arcs, arc density, etc.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
r<-2
a<-0; b<-10;

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.5

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)  #try also Yp<-runif(ny,a,b)+c(-10,10)

Arcs<-ArcsPEend1D(Xp,Yp,r)
Arcs
summary(Arcs)
plot(Arcs)

S<-Arcs$S
E<-Arcs$E

jit<-.1
yjit<-runif(nx,-jit,jit)

Xlim<-range(a,b,Xp,Yp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),pch=".",
main="arcs of PE-PCDs for points (jittered along y-axis)\n in end intervals ",
xlab=" ", ylab=" ", xlim=Xlim+xd*c(-.05,.05),ylim=3*c(-jit,jit))
abline(h=0,lty=1)
points(Xp, yjit,pch=".",cex=3)
abline(v=Yp,lty=2)
arrows(S, yjit, E, yjit, length = .05, col= 4)

ArcsPEend1D(Xp,Yp,r)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ArcsPEmid1D}}, \code{\link{ArcsPE1D}} , \code{\link{ArcsCSmid1D}},
\code{\link{ArcsCSend1D}}  and \code{\link{ArcsCS1D}}
}
