% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotPEregsTH}
\alias{plotPEregsTH}
\title{The plot of the Proportional Edge (PE) Proximity Regions for a 3D data set - one tetrahedron case}
\usage{
plotPEregsTH(
  Xp,
  r,
  th,
  M = "CM",
  main = "",
  xlab = "",
  ylab = "",
  zlab = "",
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 3D points for which PE proximity regions are constructed.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{th}{Four 3D points, stacked row-wise, each row representing a vertex of the tetrahedron.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes "CC" for circumcenter and "CM" for center of mass; default="CM".}

\item{main}{An overall title for the plot (default="").}

\item{xlab, ylab, zlab}{Titles for the x, y and z axes, respectively  (default="" for all).}

\item{xlim, ylim, zlim}{Numeric vectors of length 2, giving the x-, y- and z-coordinate ranges
(default=\code{NULL} for all).}

\item{\dots}{Additional \code{scatter3D} parameters.}
}
\value{
Plot of the PE proximity regions for points inside the tetrahedron \code{th}
(and just the points outside th)
}
\description{
Plots the points in and outside of the tetrahedron \code{th} and also the PE proximity regions  (which are also
tetrahedrons) for points inside the tetrahedron \code{th}.

PE proximity regions are constructed with respect to
tetrahedron \code{th} with expansion parameter \eqn{r \ge 1} and vertex regions are based on the center \code{M} which is
circumcenter ("CC") or center of mass ("CM") of \code{th} with default="CM", so PE proximity regions are defined
only for points inside the tetrahedron \code{th}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-10  #try also n<-20

dat<-runif.tetra(n,tetra)$g  #try also dat[,1]<-dat[,1]+1

M<-"CM"  #try also M<-"CC"
r<-1.5

plotPEregsTH(dat[1,],r,tetra)  #uses the default M="CM"
plotPEregsTH(dat[1,],r,tetra,M)

plotPEregsTH(dat[5,],r,tetra,M)

plotPEregsTH(c(.4,.4,.4),r,tetra,M)

plotPEregsTH(c(.5,.5,.5),r,tetra,M)

plotPEregsTH(dat[1:3,],r,tetra,M)

P1<-c(.1,.1,.1)
plotPEregsTH(rbind(P1,P1),r,tetra,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEregsStdTH}}, \code{\link{plotPEregsTri}} and \code{\link{plotPEregsInt}}
}
