% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{PEdomMTnd}
\alias{PEdomMTnd}
\title{The domination number of Proportional Edge Proximity Catch Digraph (PE-PCD) with
non-degeneracy centers - multiple triangle case}
\usage{
PEdomMTnd(Xp, Yp, r)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}
}
\value{
A \code{list} with two elements
\item{dom.num}{Domination number of the PE-PCD whose vertices are \code{Xp} points. PE proximity regions are
constructed with respect to the Delaunay triangles based on the \code{Yp} points with expansion parameter \eqn{r \ge 1}.}
\item{mds}{A minimum dominating set of the PE-PCD whose vertices are \code{Xp} points}
}
\description{
Returns the domination number and a minimum dominating set of PE-PCD whose vertices are the data
points in \code{Xp} in the multiple triangle case and the Delaunay triangles based on \code{Yp} points.

PE proximity regions are defined with respect to the Delaunay triangles based on \code{Yp} points with
expansion parameter \eqn{r \ge 1} and vertex regions in each triangle are based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of each Delaunay triangle or based on
circumcenter of each Delaunay triangle (default for \eqn{M=(1,1,1)} which is the center \eqn{M}
where \code{M} is one of the 3 centers that renders the asymptotic distribution of domination number
to be non-degenerate for a given value of \code{r} in \eqn{(1,1.5)} and \code{M} is center of mass for \eqn{r=1.5}.

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes the
convex hull of \code{Yp} points). Loops are allowed for the domination number.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}) more on the domination number of
PE-PCDs. Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and
the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

r<-1.5  #try also r<-2

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

PEdomMTnd(Xp,Yp,r)

PEdomMTnd(Xp,Yp,r=1.4)

r<-1.5  #try also  #r<-2
PEdomMTnd(Xp,Yp,r)  #this may be different due to random selection of the center for r in (1,1.5)

PEdomMTnd(Xp,Yp[1:3,],r)

PEdomMTnd(Xp,rbind(Yp,Yp),r)

dat.fr<-data.frame(a=Xp)
PEdomMTnd(dat.fr,Yp,r)

dat.fr<-data.frame(a=Yp)
PEdomMTnd(Xp,dat.fr,r)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEdomtri}}, \code{\link{PEdom.tetra}}, \code{\link{dom.exact}}, and \code{\link{dom.greedy}}
}
\author{
Elvan Ceyhan
}
