% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{tri2std.bas.tri}
\alias{tri2std.bas.tri}
\title{Converting a triangle to the standard basic triangle form form}
\usage{
tri2std.bas.tri(tri)
}
\arguments{
\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}
}
\value{
A \code{list} with two elements
\item{Cvec}{The nontrivial vertex \eqn{C=(c_1,c_2)} in the standard basic triangle form \eqn{T_b}.}
\item{orig.order}{Row order of the input triangle, \code{tri},
when converted to the standard basic triangle form \eqn{T_b}}
}
\description{
This function transforms any triangle, \code{tri}, to the standard basic triangle form.

The standard basic triangle form is \eqn{T_b=T((0,0),(1,0),(c_1,c_2))} where \eqn{c_1} is in \eqn{[0,1/2]},
\eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the standard basic triangle form by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence standard basic triangle form is useful for simulation
studies under the uniformity hypothesis.
}
\examples{
\dontrun{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);

tri2std.bas.tri(rbind(A,B,C))
tri2std.bas.tri(rbind(B,C,A))

A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
tri2std.bas.tri(rbind(A,B,C))
tri2std.bas.tri(rbind(A,C,B))
tri2std.bas.tri(rbind(B,A,C))
}

}
\author{
Elvan Ceyhan
}
