% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{Idom.num2PEstd.tetra}
\alias{Idom.num2PEstd.tetra}
\title{The indicator for two 3D points constituting a dominating set for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - standard regular tetrahedron case}
\usage{
Idom.num2PEstd.tetra(
  p1,
  p2,
  Xp,
  r,
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{p1, p2}{Two 3D points to be tested for constituting a dominating set of the PE-PCD.}

\item{Xp}{A set of 3D points which constitutes the vertices of the PE-PCD.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{p1} and \code{p2}, respectively.
They take the vertex labels as \code{1,2,3,4} as in the row order of the vertices in \eqn{T_h}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for checking whether points \code{p1} and \code{p2} are
data points in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 3D data set \code{Xp}),
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 3D data set \code{Xp} in the standard regular
tetrahedron \eqn{T_h=T((0,0,0),(1,0,0),(1/2,\sqrt{3}/2,0),(1/2,\sqrt{3}/6,\sqrt{6}/3))}, that is,
returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD, returns 0 otherwise.

Point, \code{p1}, is in the region of vertex \code{rv1} (default is \code{NULL}) and point, \code{p2}, is in the region of vertex \code{rv2}
(default is \code{NULL}); vertices (and hence \code{rv1} and \code{rv2}) are labeled as \code{1,2,3,4} in the order they are stacked
row-wise in \eqn{T_h}.

PE proximity region is constructed with respect to the tetrahedron \eqn{T_h} with expansion parameter \eqn{r \ge 1}
and vertex regions are based on center of mass \eqn{CM} (equivalent to circumcenter in this case).

\code{ch.data.pnts} is for checking whether points \code{p1} and \code{p2} are data points in \code{Xp} or not (default is \code{FALSE}),
so by default this function checks whether the points \code{p1} and \code{p2} would constitute a dominating set
if they actually were both in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)

n<-5 #try also n<-20
Xp<-runif.std.tetra(n)$g  #try also Xp<-cbind(runif(n),runif(n),runif(n))
r<-1.5

Idom.num2PEstd.tetra(Xp[1,],Xp[2,],Xp,r)

ind.gam2<-vector()
for (i in 1:(n-1))
 for (j in (i+1):n)
 {if (Idom.num2PEstd.tetra(Xp[i,],Xp[j,],Xp,r)==1)
  ind.gam2<-rbind(ind.gam2,c(i,j))}

ind.gam2

#or try
rv1<-rel.vert.tetraCC(Xp[1,],tetra)$rv;rv2<-rel.vert.tetraCC(Xp[2,],tetra)$rv
Idom.num2PEstd.tetra(Xp[1,],Xp[2,],Xp,r,rv1,rv2)

#or try
rv1<-rel.vert.tetraCC(Xp[1,],tetra)$rv;
Idom.num2PEstd.tetra(Xp[1,],Xp[2,],Xp,r,rv1)

#or try
rv2<-rel.vert.tetraCC(Xp[2,],tetra)$rv
Idom.num2PEstd.tetra(Xp[1,],Xp[2,],Xp,r,rv2=rv2)

P1<-c(.1,.1,.1)
P2<-c(.4,.1,.2)
Idom.num2PEstd.tetra(P1,P2,Xp,r)

Idom.num2PEstd.tetra(c(-1,-1,-1),Xp[2,],Xp,r,ch.data.pnts = FALSE)
#gives an error message if ch.data.pnts = TRUE
#since not both points, p1 and p2, are data points in Xp
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.num2PEtetra}}, \code{\link{Idom.num2PEtri}} and \code{\link{Idom.num2PEbasic.tri}}
}
\author{
Elvan Ceyhan
}
