\name{ci.plot}
\alias{ci.plot}
\title{
Plot credible interval
}
\description{
\code{ci.plot} generates credible interval plot for the population-averaged event rates given by the function \code{\link{nma.ab}}.
}
\usage{
ci.plot(summary.stat, trtname, graphtitle = "")
}
\arguments{
  \item{summary.stat}{
  a data frame read from the summary result file generated by the function \code{\link{nma.ab}}. We can use the function \code{\link[utils]{read.table}} to import the summary file.
}
  \item{trtname}{
  a vector of character string indicating treatment names. These will be shown on x-axis in the plot. The default is "trt1", "trt2", and so on.
}
  \item{graphtitle}{
  a charater string indicating the graph title. The default is an empty character.
}
}
\value{
A credible interval plot for population-averaged event rate is generated. Treatment names are placed on x-axis, while the y-axis shows the lower bound, upper bound and median of credible interval.
}
\references{
Zhang J, Carlin BP, Neaton JD, Soon GG, Nie L, Kane R, Virnig BA, Chu H (2014). "Network meta-analysis of randomized clinical trials: Reporting the proper summaries." \emph{Clin Trials} \bold{11}(2), 246--262.
}
\author{
Lifeng Lin, Jing Zhang, and Haitao Chu.
}

\examples{
## CI plot for network Middleton 2010
data(Middleton10)
attach(Middleton10)
set.seed(12345)
nma.ab(s.id = sid, t.id = tid, event.n = r, total.n = n,
       f.name = "Middleton10_", n.iter = 500, dic = FALSE)
detach(Middleton10)
ci.plot(summary.stat = read.table("Middleton10_Summary.stat", header = TRUE),
        graphtitle = "CI plot of estimated event rate for network Middleton10",
        trtname = c("First generation", "Hysterectomy", "Second generation",
        "Mirena"))
}