% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_tools.R
\name{search_browse}
\alias{search_browse}
\title{Search and browse the web for specified terms}
\usage{
search_browse(search_terms, engine = "google", base_url = NULL)
}
\arguments{
\item{search_terms}{A character vector of search terms to be searched.}

\item{engine}{A character string specifying the search engine to use (default is "google").
Supported engines: "google", "bing".}

\item{base_url}{A character string specifying the base URL for web searches. If not provided,
the function will use a default URL based on the chosen search engine.}
}
\value{
No return value
}
\description{
This function takes a vector of search terms, an optional search engine (default is Google),
and an optional base URL to perform web searches. It opens the default web browser
with search results for each term.
}
\examples{
\dontrun{
search_terms <- c(
  "s__Pandoraea_pnomenusa",
  "s__Alicycliphilus_sp._B1"
)

# Using Google search engine
search_browse(search_terms, engine = "google")

# Using Bing search engine
search_browse(search_terms, engine = "bing")
}

}
