% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavtrans.R
\name{WavTransf2D}
\alias{WavTransf2D}
\title{Forward average-interpolation 2D wavelet transform}
\usage{
WavTransf2D(P, order = c(3, 3), jmax, metric = "Riemannian", progress = T,
  ...)
}
\arguments{
\item{P}{a (\eqn{d,d,n1,n2})-dimensional array of Hermitian PD matrices, with \eqn{n_1 = 2^{J_1}} and \eqn{n_2 = 2^{J_2}}
for some \eqn{J_1, J_2 > 0}.}

\item{order}{a 2-dimensional numeric vector of odd integers larger or equal to 1 corresponding to the marginal
orders of the intrinsic 2D AI refinement scheme, defaults to \code{order = c(3, 3)}. Note that the computational cost
significantly increases if \code{max(order) > 9} as the wavelet transform no longer uses a fast wavelet refinement scheme based
on pre-determined weights.}

\item{jmax}{the maximum scale up to which the wavelet coefficients are computed. If \code{jmax} is not
specified it is set equal to the maximum possible scale \code{jmax = max(J1, J2) - 1}.}

\item{metric}{the metric that the space of HPD matrices is equipped with. The default choice is \code{"Riemannian"},
but this can be one of: \code{"Riemannian"}, \code{"logEuclidean"}, \code{"Cholesky"}, \code{"rootEuclidean"} or
\code{"Euclidean"}. The intrinsic AI wavelet transform fundamentally relies on the chosen metric.}

\item{progress}{should a console progress bar be displayed? Defaults to \code{progress = T}.}

\item{...}{additional arguments for internal use.}
}
\value{
The function returns a list with three components:
\item{D }{the 2D pyramid of wavelet coefficients. This is a list of arrays, where each 4-dimensional array contains the
(\eqn{d,d})-dimensional wavelet coefficients in a 2D grid of locations from the finest wavelet scale \code{j = jmax}
up to the coarsest wavelet scale \code{j = 0}.}
\item{D.white }{the 2D pyramid of whitened wavelet coefficients. The structure of \code{D.white} is the same as
\code{D}, but with the wavelet coefficients replaced by their whitened counterparts as explained in
(Chau and von Sachs, 2017).}
\item{M0 }{a numeric array containing the midpoint(s) at the coarsest scale \code{j = 0} in the 2D midpoint pyramid.}
}
\description{
\code{WavTransf2D} computes the forward intrinsic average-interpolation (AI) wavelet transform of a
rectangular surface in the manifold of HPD matrices equipped with a metric specified by the user
(e.g. the Riemannian metric).
}
\details{
The 4-dimensional array \code{P} corresponds to a discretized rectangular surface of \eqn{(d,d)}-dimensional
HPD matrices. The rectangular surface is of size \eqn{n_1} by \eqn{n_2}, where both \eqn{n_1} and
\eqn{n_2} are supposed to be dyadic numbers. \code{WavTransf2D} then computes the intrinsic AI wavelet transform
of \code{P} based on the given refinement orders and the chosen metric. If both marginal refinement orders are
smaller or equal to 9, the function computes the wavelet transform using a fast wavelet refinement scheme based on weighted
geometric averages with pre-determined weights. If one of the marginal refinement order is an odd integer larger than 9,
the wavelet refinement scheme is based on intrinsic polynomial surface prediction using Neville's algorithm on the
Riemannian manifold (\code{\link{pdNeville}}). By default \code{WavTransf2D} computes the intrinsic 2D AI wavelet transform
equipping the space of HPD matrices with (i) the Riemannian metric. Instead, the space of HPD matrices can also be
equipped with one of the following metrics; (ii) log-Euclidean metric, the Euclidean inner product between matrix logarithms,
(iii) Cholesky metric, the Euclidean inner product between Cholesky decompositions, (iv) Euclidean metric and
(v) root-Euclidean metric. The default choice (Riemannian) has several appealing properties not shared by the
other metrics, see (Chau and von Sachs, 2017a) for more details.
}
\examples{
P <- rExamples2D(c(2^4, 2^4), 2, example = "tvar")
P.wt <- WavTransf2D(P$f)

}
\references{
Chau, J. and von Sachs, R. (2017a). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.
}
\seealso{
\code{\link{InvWavTransf2D}}, \code{\link{pdSpecEst2D}}, \code{\link{pdNeville}}
}
