% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODAC.R
\name{ODAC.initialize}
\alias{ODAC.initialize}
\title{ODAC initialize}
\usage{
ODAC.initialize(ipdata, control, config)
}
\arguments{
\item{ipdata}{individual participant data}

\item{control}{pda control data}

\item{config}{local site configuration}
}
\value{
list(T_i = T_i, bhat_i = fit_i$coef, Vhat_i = summary(fit_i)$coef[,2]^2, site=control$mysite, site_size= nrow(ipdata))
}
\description{
ODAC initialize
}
\references{
Rui Duan, et al. "Learning from local to global: An efficient distributed algorithm for modeling time-to-event data". 
              Journal of the American Medical Informatics Association, 2020, https://doi.org/10.1093/jamia/ocaa044
             Chongliang Luo, et al. "ODACH: A One-shot Distributed Algorithm for Cox model with Heterogeneous Multi-center Data".
              medRxiv, 2021, https://doi.org/10.1101/2021.04.18.21255694
}
\keyword{internal}
