% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prsp_stream.R
\name{prsp_stream}
\alias{prsp_stream}
\title{Stream comment scores with Perspective API}
\usage{
prsp_stream(.data, text = NULL, text_id = NULL, ..., safe_output = F,
  verbose = F)
}
\arguments{
\item{.data}{a dataset with a text and text_id column.}

\item{text}{a character vector with text you want to score.}

\item{text_id}{a unique ID for the text that you supply (required)}

\item{...}{arguments passed to \code{\link{prsp_score}}.}

\item{safe_output}{wraps the function into a \code{purrr::safely} environment (defaults to \code{FALSE}). Loop will run without pause and catch + output errors in a tidy \code{tibble} along with the results.}

\item{verbose}{narrates the streaming procedure (defaults to \code{FALSE}).}
}
\value{
a \code{tibble}
}
\description{
This function wraps \code{\link{prsp_score}} and loops over your text input. Provide a character string with your text and which scores you want to obtain. Make sure to keep track of your ratelimit with on \href{https://console.cloud.google.com/iam-admin/quotas}{the cloud console quota usage page}.
}
\details{
For more details see \code{?peRspective} or \href{https://github.com/conversationai/perspectiveapi/blob/master/api_reference.md}{Perspective API documentation}
}
\examples{
\dontrun{
## Create a mock tibble
text_sample <- tibble(
ctext = c("You wrote this? Wow. This is dumb and childish, please go f**** yourself.",
          "I don't know what to say about this but it's not good. The commenter is just an idiot",
          "This goes even further!",
          "What the hell is going on?",
          "Please. I don't get it. Explain it again",
          "Annoying and irrelevant! I'd rather watch the paint drying on the wall!"),
textid = c("#efdcxct", "#ehfcsct", 
           "#ekacxwt",  "#ewatxad", 
           "#ekacswt",  "#ewftxwd")
)
           
## GET TOXICITY and SEVERE_TOXICITY Scores for a dataset with a text column
text_sample \%>\%
prsp_stream(text = ctext,
            text_id = textid,
            score_model = c("TOXICITY", "SEVERE_TOXICITY"))
  
## Safe Output argument means will not stop on error
prsp_stream(text = ctext,
           text_id = textid,
           score_model = c("TOXICITY", "SEVERE_TOXICITY"),
           safe_output = T)
           
           
## verbose = T means you get pretty narration of your scoring procedure
prsp_stream(text = ctext,
           text_id = textid,
           score_model = c("TOXICITY", "SEVERE_TOXICITY"),
           safe_output = T,
           verbose = T)
}
}
