% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{leader_codes}
\alias{leader_codes}
\title{A Data Set of Leader Codes Across Archigos 4.1, Archigos 2.9, and the LEAD Data}
\format{
A data frame the following four variables.
\describe{
\item{\code{obsid}}{the observation ID in the Archigos data}
\item{\code{leadid}}{the leader ID in version 4.1 of the Archigos data}
\item{\code{leadid29}}{the leader ID in version 2.9 of the Archigos data}
\item{\code{leaderid}}{the leader ID in the LEAD data}
}
}
\usage{
leader_codes
}
\description{
This is a simple data set that matches, as well as one can, leader codes across Archigos 4.1, Archigos 2.9, and the LEAD data set.
}
\details{
These data treat version 4.1 of the Archigos data as the gospel leader data (if you will) for which  the observation ID (\code{obsid})
is the master code indicating a leader tenure period. It also builds in an assumption that various observations that duplicate in the
LEAD data should not have duplicated. This concerns Francisco Aguilar Barquer (who appears twice), Emile Reuter (who appears twice),
and Gunnar Thoroddsen (who appears three times) in the LEAD data despite having uninterrupted tenures in office. None of the covariates
associated with these leaders change in the LEAD data, which is why I assume they were duplicates.
}
\keyword{datasets}
