% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_extdata.R
\name{download_extdata}
\alias{download_extdata}
\title{Download Some Extra Data for Peace Science Research}
\usage{
download_extdata(overwrite = FALSE)
}
\arguments{
\item{overwrite}{logical, defaults to FALSE. If FALSE, the function
checks to see if you've already downloaded the data and, if you already
have, it does nothing. If TRUE, the function redownloads the data.}
}
\value{
\code{download_extdata()} downloads some extra data stored on
my website (\url{http://svmiller.com}) and sticks them in the \emph{extdata}
directory in the package.
}
\description{
\code{download_extdata()} leverages R's \code{inst} directory
flexibility to allow you to download some extra data and store it in
the package.
}
\section{A Description of Various Data Sets This Will Download}{
Running \code{download_extdata()} returns the following data that will be
stored in the package's \code{extdata} directory.
\subsection{Correlates of War Dyadic Trade Data Set (v. 4.0)}{

These are directed dyad-year-level data for dyadic trade from the
Correlates of War project. The trade values presented here
have been rounded to three decimal points to conserve space. The
data downloaded by this function are about 4.1 megabytes in size.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{ccode1} \tab a numeric vector for the Correlates of War state code for the first state \cr
   \code{ccode2} \tab a numeric vector for the Correlates of War state code for the second state \cr
   \code{year} \tab the year \cr
   \code{flow1} \tab imports of \code{ccode1} from \code{ccode2}, in current million USD \cr
   \code{flow2} \tab imports of \code{ccode2} from \code{ccode1}, in current million USD \cr
   \code{smoothflow1} \tab smoothed \code{flow1} values \cr
   \code{smoothflow2} \tab smoothed \code{flow2} values \cr
}

}

\subsection{Directed Leader Dyad-Year Data, 1870-2015 (CoW States)}{

These are all directed leader dyad-year data from 1870-2015. Data come
from the Archigos data (version 4.1). The data are standardized to just
those observations where both leaders and states appear in the CoW state
system data. The data downloaded by this function are about 2 megabytes
in size.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{year} \tab the year \cr
   \code{obsid1} \tab the unique Archigos (v. 4.1) observation ID for the first leader \cr
   \code{obsid2} \tab the unique Archigos (v. 4.1) observation ID for the second leader \cr
   \code{ccode1} \tab a numeric vector for the Correlates of War state code for the first state \cr
   \code{ccode2} \tab a numeric vector for the Correlates of War state code for the second state \cr
   \code{gender1} \tab the gender of \code{obsid1} ("M" or "F") \cr
   \code{gender2} \tab the gender of \code{obsid2} ("M" or "F") \cr
   \code{leaderage1} \tab the approximate age (i.e. \code{year - yrborn}) for \code{obsid1} in the year \cr
   \code{leaderage2} \tab the approximate age (i.e. \code{year - yrborn}) for \code{obsid2} in the year \cr
   \code{yrinoffice1} \tab a running count for the tenure of \code{obsid1}, starting at 1. \cr
   \code{yrinoffice2} \tab a running count for the tenure of \code{obsid2}, starting at 1. \cr
}

}

\subsection{Directed Leader Dyad-Year Data, 1870-2015 (Gleditsch-Ward States)}{

These are all directed leader dyad-year data from 1870-2015. Data come from
the Archigos data (version 4.1). The data represent every possible dyadic
leader-pairing in the Archigos data (which is denominated in the
Gleditsch-Ward system), but standardizes leader dyad-years to Gleditsch-Ward
state system dates. The data downloaded by this function
are about 2.2 megabytes in size.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{year} \tab the year \cr
   \code{obsid1} \tab the unique Archigos (v. 4.1) observation ID for the first leader \cr
   \code{obsid2} \tab the unique Archigos (v. 4.1) observation ID for the second leader \cr
   \code{gwcode1} \tab a numeric vector for the Gleditsch-Ward state code for the first state \cr
   \code{gwcode2} \tab a numeric vector for the Gleditsch-Ward state code for the second state \cr
   \code{gender1} \tab the gender of \code{obsid1} ("M" or "F") \cr
   \code{gender2} \tab the gender of \code{obsid2} ("M" or "F") \cr
   \code{leaderage1} \tab the approximate age (i.e. \code{year - yrborn}) for \code{obsid1} in the year \cr
   \code{leaderage2} \tab the approximate age (i.e. \code{year - yrborn}) for \code{obsid2} in the year \cr
   \code{yrinoffice1} \tab a running count for the tenure of \code{obsid1}, starting at 1. \cr
   \code{yrinoffice2} \tab a running count for the tenure of \code{obsid2}, starting at 1. \cr
}

}

\subsection{Chance-Corrected Measures of Foreign Policy Similarity (FPSIM, v. 2)}{

The FPSIM data set provides measures of foreign policy similarity of dyads
based on alliance ties (Correlates of War, version 4.1) and UN General
Assembly voting (Voeten, version 17) for all members of the Correlates of
War state system. The alliance data cover the time period from 1816 to 2012,
and the UN voting data from 1946 to 2015. The similarity measures include
various versions of Ritter and Signorino's \emph{S} (weighted/non-weighted by
material capabilities; squared/absolute distance metrics) as well as the
chance-corrected measures Cohen's (1960) kappa and Scott's (1955) pi. The
measures based on alliance data come in two versions: one is based on valued
alliance ties and the other is based on binary alliance ties. Data were
last updated on December 7, 2017, and this description was effectively
plagiarized (with his blessing) from Frank Haege's Dataverse.

These data are directed dyad-years with 17 columns and 1,872,198
observations. They will almost certainly be the largest data set
I nudge/ask you to download remotely. The file containing this
information is 18.6 MB in size. To reduce size further, these
decimal points have also been rounded to three spots.

Haege generated all estimates of dyadic foreign policy similarity, except
for the \code{taub} column. That was generated separately, by me.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{year} \tab the year \cr
   \code{ccode1} \tab the Correlates of War state code for the first state \cr
   \code{ccode2} \tab the Correlates of War state code for the second state \cr
   \code{taub} \tab Tau-b (valued alliance data) \cr
   \code{srsvas} \tab unweighted \emph{S} (squared distances, valued alliance data) \cr
   \code{srswvas} \tab weighted \emph{S} (squared distances, valued alliance data) \cr
   \code{srsvaa} \tab unweighted \emph{S} (absolute distances, valued alliance data) \cr
   \code{srswvaa} \tab weighted \emph{S} (absolute distances, valued alliance data) \cr
   \code{kappava} \tab Kappa (squared distances, valued alliance data) \cr
   \code{piva} \tab Pi (squared distances, valued alliance data) \cr
   \code{srsba} \tab Unweighted \emph{S} (binary alliance data) \cr
   \code{srswba} \tab Weighted \emph{S} (binary alliance data) \cr
   \code{kappaba} \tab Kappa (binary alliance data) \cr
   \code{piba} \tab Pi denominator (binary alliance data) \cr
   \code{srsvvs} \tab Unweighted \emph{S} (squared distances, valued UN voting data) \cr
   \code{srsvva} \tab Unweighted \emph{S} (absolute distances, valued UN voting data) \cr
   \code{kappavv} \tab Kappa (squared distances, valued UN voting data) \cr
   \code{pivv} \tab Pi (squared distances, valued UN voting data) \cr
}

}

\subsection{(Non-Directed) Dyadic Minimum Distance Data \emph{Plus} (CoW States)}{

These are \emph{non-directed} dyadic minimum distance data from Schvitz et al.
(2022) for all Correlates of War states from the start of 1886 to the
end of 2019. Note that I call these "data \emph{plus}", with the idea of
informally branding these as a kind of augmentation of what you might
otherwise do with the \pkg{cshapes} package. This data set has over
4.4 million rows for each dyadic minimum distance for all available
years. Within each year, there is a recorded minimum distance for Jan. 1,
June 30, Dec. 31 and, in addition, any day within the year where the
composition of the international system (or shape of a state) changed, as
recorded in \pkg{cshapes}. Sometimes these changes concern the dyadic
minimum distance; sometimes they don't. For example, the League of Nations
is responsible for a lot shape changes (i.e. system entry) in the CoW state
system data in the year 1920. That obviously won't change the dyadic minimum
distance between the U.S. and Canada, which will always be zero. Sometimes the
start of the year (Jan. 1), the midpoint of the year (June 30), or the end of
the year (Dec. 31) coincides with a system change. Often it doesn't. Note that
a referent day (Jan. 1, June 30, Dec. 31) may not appear in a given year for
a given dyad if that date exists outside CoW state system membership. For
example, Canada doesn't appear as a state system member until Jan. 10, 1920.
The goal of this data set is allow you to more quickly generate dyadic
minimum distances within \pkg{peacesciencer}'s functionality if you are
proficient in \pkg{tidyverse} verbs. You could also use it to highlight
how often the dyadic minimum distance may vary within a year for a given
dyad.

Despite the dimensions of the data set, it's not too big of a download. The
data are about 1.7 MB in size.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{ccode1} \tab the Correlates of War state code for the first state \cr
   \code{ccode2} \tab the Correlates of War state code for the second state \cr
   \code{year} \tab the year \cr
   \code{date} \tab a date, coinciding with either a system change date or a referent day (i.e. Jan. 1, June 30, Dec. 31) \cr
   \code{change_date} \tab a date that, when present, indicates the shape of the system changed on that day \cr
   \code{mindist} \tab the dyadic minimum distance (in kilometers) \cr
}

}

\subsection{(Non-Directed) Dyadic Minimum Distance Data \emph{Plus} (G-W States)}{

These are \emph{non-directed} dyadic minimum distance data from Schvitz et al.
(2022) for all Gleditsch-Ward states from the start of 1886 to the
end of 2019. Note that I call these "data \emph{plus}", with the idea of
informally branding these as a kind of augmentation of what you might
otherwise do with the \pkg{cshapes} package. This data set has over
3.7 million rows for each dyadic minimum distance for all available
years. Within each year, there is a recorded minimum distance for Jan. 1,
June 30, Dec. 31 and, in addition, any day within the year where the
composition of the international system (or shape of a state) changed, as
recorded in \pkg{cshapes}. Sometimes these changes concern the dyadic
minimum distance; sometimes they don't. For example, the dissolution of
the Soviet Union is responsible for a lot shape changes (i.e. system entry) in
1991. That obviously won't change the dyadic minimum
distance between the U.S. and Canada, which will always be zero. Sometimes the
start of the year (Jan. 1), the midpoint of the year (June 30), or the end of
the year (Dec. 31) coincides with a system change. Often it doesn't. Note that
a referent day (Jan. 1, June 30, Dec. 31) may not appear in a given year for
a given dyad if that date exists outside G-W state system membership. For
example, Haiti disappears from the state system on July 4, 1915 and
reappears on Aug. 15, 1934. That means there won't be any dyadic minimum
distance observations with the U.S., for example, on Dec. 31, 1915 or June
30, 1934. The goal of this data set is allow you to more quickly generate dyadic
minimum distances within \pkg{peacesciencer}'s functionality if you are
proficient in \pkg{tidyverse} verbs. You could also use it to highlight
how often the dyadic minimum distance may vary within a year for a given
dyad.

Despite the dimensions of the data set, it's not too big of a download. The
data are about 1.4 MB in size.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{gwcode1} \tab the Gleditsch-Ward state code for the first state \cr
   \code{gwcode2} \tab the Gleditsch-Ward state code for the second state \cr
   \code{year} \tab the year \cr
   \code{date} \tab a date, coinciding with either a system change date or a referent day (i.e. Jan. 1, June 30, Dec. 31) \cr
   \code{change_date} \tab a date that, when present, indicates the shape of the system changed on that day \cr
   \code{mindist} \tab the dyadic minimum distance (in kilometers) \cr
}

}
}

\examples{

\dontrun{
# Here's where the data are going to be downloaded.
system.file("extdata", package="peacesciencer")
# Now, let's download the data.
download_extdata()
}
}
\references{
Barbieri, Katherine, Omar M. G. Keshk, and Brian Pollins. 2009. "TRADING DATA: Evaluating our Assumptions and Coding Rules."
\emph{Conflict Management and Peace Science}. 26(5): 471-491.

Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009. "Introducing Archigos: A Dataset of Political Leaders"
\emph{Journal of Peace Research} 46(2): 269--83.

Haege, Frank. 2011. "Choice or Circumstance? Adjusting Measures of Foreign Policy Similarity for Chance Agreement."
\emph{Political Analysis} 19(3): 287-305.

Schvitz, Guy, Luc Girardin, Seraina Ruegger, Nils B. Weidmann, Lars-Erik Cederman,
and Kristian Skrede Gleditsch. 2022. "Mapping The International System, 1886-2017:
The \code{CShapes} 2.0 Dataset." \emph{Journal of Conflict Resolution}. 66(1): 144-161.

Weidmann, Nils B. and Kristian Skrede Gleditsch. 2010. "Mapping and Measuring Country Shapes: The \code{cshapes} Package."
\emph{The R Journal} 2(1): 18-24.
}
\author{
Steven V. Miller
}
