% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numint.R
\name{isNumint}
\alias{isNumint}
\alias{allNumint}
\alias{anyNumint}
\alias{allInteger}
\alias{anyInteger}
\alias{allFactor}
\alias{anyFactor}
\alias{allNumeric}
\alias{anyNumeric}
\alias{uniqueClass}
\alias{whichNumint}
\alias{whichInteger}
\alias{whichFactor}
\alias{whichNumeric}
\title{Tests for data types}
\usage{
isNumint(x)

allNumint(x)

anyNumint(x)

whichNumint(x)

allInteger(x)

anyInteger(x)

whichInteger(x)

allFactor(x)

anyFactor(x)

whichFactor(x)

allNumeric(x)

anyNumeric(x)

whichNumeric(x)

uniqueClass(x)
}
\arguments{
\item{x}{Object to be tested.}
}
\value{
\code{TRUE} or \code{FALSE} depending on whether \code{x} contains a given
data type.
}
\description{
Evaluate the data type contained in an object.
}
\examples{
# Vector of integers
x <- 1:10
isNumint(x) # FALSE

# Vector of numeric integers
x <- as.numeric(x)
isNumint(x) # TRUE

# Vector of numeric values
x <- c(1.1, 1, 1, 1, 2)
isNumint(x) # FALSE
allNumint(x) # FALSE
anyNumint(x) # TRUE
whichNumint(x)

# Single numeric integer
isNumint(1) # TRUE

# Single numeric value
isNumint(1.1) # FALSE
}
\seealso{
\code{\link[base]{is.numeric}}, \code{\link[base]{is.integer}},
\code{\link[base]{is.factor}}.
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
