% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_attach.R
\name{marker_attach}
\alias{marker_attach}
\alias{setMarkers}
\alias{addMarkers}
\title{Attach markers to pedigrees}
\usage{
setMarkers(
  x,
  m = NULL,
  alleleMatrix = NULL,
  locusAttributes = NULL,
  missing = 0,
  sep = NULL,
  checkCons = TRUE
)

addMarkers(
  x,
  m = NULL,
  alleleMatrix = NULL,
  locusAttributes = NULL,
  missing = 0,
  sep = NULL,
  checkCons = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object}

\item{m}{Either a single \code{marker} object or a list of \code{marker} objects}

\item{alleleMatrix}{A matrix with \code{pedsize(x)} rows, containing the observed
alleles for one or several markers. The matrix must have either 1 or 2
columns per marker. If the former, then a \code{sep} string must be a given, and
will be used to split all entries.}

\item{locusAttributes}{A list of lists, with attributes for each marker. See
Details for possible attributes.}

\item{missing}{A single character (or coercible to one) indicating the symbol
for missing alleles.}

\item{sep}{If this is a single string, each entry of \code{alleleMatrix} is
interpreted as a genotype, and will be split by calling \code{strsplit(..., split = sep, fixed = TRUE)}. If \code{alleleMatrix} contains entries with "/",
this will be taken as separator by default. (To override this behaviour,
put \code{sep = FALSE}.)}

\item{checkCons}{A logical. If TRUE (default), each marker is checked for
consistency with \code{x}.}
}
\value{
A \code{ped} object.
}
\description{
In many applications it is useful to \emph{attach} markers to their associated
\code{ped} object. In particular for bigger projects with many markers, this makes
it easier to manipulate the dataset as a unit. The function \code{setMarkers()}
replaces all existing markers with the supplied ones, while \code{addMarkers()}
appends the supplied markers to any existing ones. Note that there is also
the function \code{\link[=addMarker]{addMarker()}}, which creates and attaches a single marker in one
go.
}
\details{
The most general format of \code{locusAttributes} a list of lists, one for each
marker, where possible entries in the inner lists are as follows (default
values in parenthesis):
\itemize{
\item \code{alleles} : a character vector with allele labels
\item \code{afreq} :  a numeric vector with allele frequencies (\code{rep.int(1/L, L)},
where \code{L = length(alleles)})
\item \code{chrom} : chromosome number (NA)
\item \code{posMb} : physical location in megabases (NA)
\item \code{name} : marker name (NA)
\item \code{mutmod} : mutation model, or model name (NULL)
\item \code{rate} : mutation model parameter (NULL)
}

If \code{locusAttributes} is just a single list of attributes (not a list of
lists), then it is repeated to match the number of markers. In particular,
the shortcut \code{locusAttributes = "snp-12"} sets all markers to be SNPs with
alleles 1 and 2.`

Two alternative format of \code{locusAttributes} are allowed: If a data.frame or
matrix is given, an attempt is made to interpret it as a frequency database
in \verb{allelic ladder} format. Such an interpretation is also attempted if
\code{locusAttributes} is a list of named frequency vectors (where the names are
the allele labels).
}
\examples{
x = singleton(1)
m1 = marker(x, `1` = "1/2")
m2 = marker(x, `1` = "a/b")

# Attach to x
x1 = setMarkers(x, list(m1, m2))

# Reversing the order of the markers
setMarkers(x, list(m2, m1))

# Alternative syntax, adding one marker at a time
x2 = x |> addMarker(`1` = "1/2") |> addMarker(`1` = "a/b")

stopifnot(identical(x1, x2))

}
\seealso{
\code{\link[=addMarker]{addMarker()}}
}
