// Generated by rstantools.  Do not edit by hand.

/*
    pema is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pema is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pema.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_hs_prior_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_hs_prior");
    reader.add_event(47, 45, "end", "model_hs_prior");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
horseshoe(const T0__& z,
              const T1__& lambda,
              const T2__& tau,
              const T3__& c2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 14;
        local_scalar_t__ lambda2(DUMMY_VAR__);
        (void) lambda2;  // dummy to suppress unused var warning
        stan::math::initialize(lambda2, DUMMY_VAR__);
        stan::math::fill(lambda2, DUMMY_VAR__);
        stan::math::assign(lambda2,square(lambda));
        current_statement_begin__ = 15;
        local_scalar_t__ lambda_tilde(DUMMY_VAR__);
        (void) lambda_tilde;  // dummy to suppress unused var warning
        stan::math::initialize(lambda_tilde, DUMMY_VAR__);
        stan::math::fill(lambda_tilde, DUMMY_VAR__);
        stan::math::assign(lambda_tilde,stan::math::sqrt(((c2 * lambda2) / (c2 + (pow(tau, 2) * lambda2)))));
        current_statement_begin__ = 16;
        return stan::math::promote_scalar<fun_return_scalar_t__>(((z * lambda_tilde) * tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct horseshoe_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
    operator()(const T0__& z,
              const T1__& lambda,
              const T2__& tau,
              const T3__& c2, std::ostream* pstream__) const {
        return horseshoe(z, lambda, tau, c2, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_hs_prior
  : public stan::model::model_base_crtp<model_hs_prior> {
private:
        double df;
        double df_global;
        double df_slab;
        double scale_global;
        double scale_slab;
public:
    model_hs_prior(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_hs_prior(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_hs_prior_namespace::model_hs_prior";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "df", "double", context__.to_vec());
            df = double(0);
            vals_r__ = context__.vals_r("df");
            pos__ = 0;
            df = vals_r__[pos__++];
            check_greater_or_equal(function__, "df", df, 0);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "df_global", "double", context__.to_vec());
            df_global = double(0);
            vals_r__ = context__.vals_r("df_global");
            pos__ = 0;
            df_global = vals_r__[pos__++];
            check_greater_or_equal(function__, "df_global", df_global, 0);
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "df_slab", "double", context__.to_vec());
            df_slab = double(0);
            vals_r__ = context__.vals_r("df_slab");
            pos__ = 0;
            df_slab = vals_r__[pos__++];
            check_greater_or_equal(function__, "df_slab", df_slab, 0);
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "scale_global", "double", context__.to_vec());
            scale_global = double(0);
            vals_r__ = context__.vals_r("scale_global");
            pos__ = 0;
            scale_global = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale_global", scale_global, 0);
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "scale_slab", "double", context__.to_vec());
            scale_slab = double(0);
            vals_r__ = context__.vals_r("scale_slab");
            pos__ = 0;
            scale_slab = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale_slab", scale_slab, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 28;
            num_params_r__ += 1;
            current_statement_begin__ = 29;
            num_params_r__ += 1;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_hs_prior() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 28;
        if (!(context__.contains_r("zb")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zb missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zb");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "zb", "double", context__.to_vec());
        double zb(0);
        zb = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(zb);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zb: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("hs_local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hs_local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hs_local");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hs_local", "double", context__.to_vec());
        double hs_local(0);
        hs_local = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(hs_local);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hs_local: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("hs_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hs_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hs_global");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hs_global", "double", context__.to_vec());
        double hs_global(0);
        hs_global = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, hs_global);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hs_global: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("hs_slab")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hs_slab missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hs_slab");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hs_slab", "double", context__.to_vec());
        double hs_slab(0);
        hs_slab = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, hs_slab);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hs_slab: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 28;
            local_scalar_t__ zb;
            (void) zb;  // dummy to suppress unused var warning
            if (jacobian__)
                zb = in__.scalar_constrain(lp__);
            else
                zb = in__.scalar_constrain();
            current_statement_begin__ = 29;
            local_scalar_t__ hs_local;
            (void) hs_local;  // dummy to suppress unused var warning
            if (jacobian__)
                hs_local = in__.scalar_constrain(lp__);
            else
                hs_local = in__.scalar_constrain();
            current_statement_begin__ = 30;
            local_scalar_t__ hs_global;
            (void) hs_global;  // dummy to suppress unused var warning
            if (jacobian__)
                hs_global = in__.scalar_lb_constrain(0, lp__);
            else
                hs_global = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 31;
            local_scalar_t__ hs_slab;
            (void) hs_slab;  // dummy to suppress unused var warning
            if (jacobian__)
                hs_slab = in__.scalar_lb_constrain(0, lp__);
            else
                hs_slab = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 34;
            local_scalar_t__ b;
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 35;
            stan::math::assign(b, horseshoe(zb, hs_local, hs_global, (pow(scale_slab, 2) * hs_slab), pstream__));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 34;
            if (stan::math::is_uninitialized(b)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            // model body
            current_statement_begin__ = 39;
            lp_accum__.add(std_normal_log(zb));
            current_statement_begin__ = 40;
            lp_accum__.add((student_t_log(hs_local, df, 0, 1) - stan::math::log(0.5)));
            current_statement_begin__ = 42;
            lp_accum__.add((student_t_log(hs_global, df_global, 0, scale_global) - (1 * stan::math::log(0.5))));
            current_statement_begin__ = 44;
            lp_accum__.add(inv_gamma_log(hs_slab, (0.5 * df_slab), (0.5 * df_slab)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("zb");
        names__.push_back("hs_local");
        names__.push_back("hs_global");
        names__.push_back("hs_slab");
        names__.push_back("b");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_hs_prior_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double zb = in__.scalar_constrain();
        vars__.push_back(zb);
        double hs_local = in__.scalar_constrain();
        vars__.push_back(hs_local);
        double hs_global = in__.scalar_lb_constrain(0);
        vars__.push_back(hs_global);
        double hs_slab = in__.scalar_lb_constrain(0);
        vars__.push_back(hs_slab);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 34;
            double b;
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 35;
            stan::math::assign(b, horseshoe(zb, hs_local, hs_global, (pow(scale_slab, 2) * hs_slab), pstream__));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(b);
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_hs_prior";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "zb";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_local";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_global";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_slab";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "zb";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_local";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_global";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_slab";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_hs_prior_namespace::model_hs_prior stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
