% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.default.lambda.R
\name{find.default.lambda}
\alias{find.default.lambda}
\title{Default values for L1 penalty in conditional logistic regression}
\usage{
find.default.lambda(
  response,
  stratum,
  penalized,
  unpenalized = NULL,
  alpha = 1,
  p = NULL,
  standardize = FALSE,
  event,
  nfolds = 10
)
}
\arguments{
\item{response}{The response variable, either a 0/1 vector or a factor with two levels.}

\item{stratum}{A numeric vector with stratum membership of each observation.}

\item{penalized}{A matrix of penalized covariates.}

\item{unpenalized}{A matrix of additional unpenalized covariates.}

\item{alpha}{The elastic net mixing parameter, a number between 0 and 1.
alpha=0 would give pure ridge; alpha=1 gives lasso. Pure ridge penalty is never obtained in this implementation since alpha must be positive.}

\item{p}{The sizes of blocks of covariates,
a numerical vector of the length equal to the number of blocks,
and with the sum equal to the number of penalized covariates.
If missing, all covariates are treated the same and a single penalty is applied.}

\item{standardize}{Should the covariates be standardized, a logical value.}

\item{event}{If response is a factor, the level that
should be considered a success in the logistic regression.}

\item{nfolds}{The number of folds used in cross-validation. Default is 10.}
}
\value{
A numeric vector
giving a  sequence of L1 penalties if \code{p} is missing, or a list
of per-block penalty sequences otherwise.
}
\description{
Performs cross validation to determine reasonable default values for L1 penalty
in a conditional logistic regression
}
\details{
The function \code{find.default.lambda} is used to obtain a sequence of reasonable values
of the parameter \code{lambda}. In the presence of blocks of covariates, a separate
sequence is obtained for each block and the function returns a list. The function is
based on cross-validation implemented in the \code{clogitL1} package. For each block,
a separate conditional logistic model is fit (together with unpenalized covariates if provided)
and  two \code{lambda} values a) \code{minCV_lambda} minimizing cross-validated deviance  and b) \code{minCV1se_lambda}
satisfying 1-SE rule, are obtained. Two additional values of \code{lambda} are obtained
as a midpoint between the two \code{(minCV_lambda + minCV1se_lambda)/2} and symmetrically \verb{(3*minCV_lambda - minCV1se_lambda)/2)}
(on a log-scale). If \code{minCV_lambda = minCV1se_lambda}, a shorter sequnce is returned. Note that
cross-validation includes random data splitting, meaning
that obtained values can vary significantly between different runs.
}
\examples{
set.seed(123)
# simulate covariates (pure noise in two blocks of 20 and 80 variables)
X <- cbind(matrix(rnorm(4000, 0, 1), ncol = 20), matrix(rnorm(16000, 2, 0.6), ncol = 80))
p <- c(20,80)
# stratum membership
stratum <- sort(rep(1:100, 2))

# the response
Y <- rep(c(1, 0), 100)

# obtain a list with a separate sequence for each block
\donttest{
lambda.list <- find.default.lambda(response = Y,
                                   penalized = X, stratum = stratum, p = p)}

# obtain a single sequence
\donttest{
lambda.seq <- find.default.lambda(response = Y,
                                   penalized = X, stratum = stratum)}
}
