% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penppml-package.R
\docType{package}
\name{penppml-package}
\alias{penppml}
\alias{penppml-package}
\title{penppml: Penalized Poisson Pseudo Maximum Likelihood Regression}
\description{
A set of tools that enables efficient estimation of penalized Poisson Pseudo Maximum Likelihood regressions, using lasso or ridge penalties, for models that feature one or more sets of high-dimensional fixed effects. The methodology is based on Breinlich, Corradi, Rocha, Ruta, Santos Silva, and Zylkin (2021) \url{http://hdl.handle.net/10986/35451} and takes advantage of the method of alternating projections of Gaure (2013) \doi{10.1016/j.csda.2013.03.024} for dealing with HDFE, as well as the coordinate descent algorithm of Friedman, Hastie and Tibshirani (2010) \doi{10.18637/jss.v033.i01} for fitting lasso regressions. The package is also able to carry out cross-validation and to implement the plugin lasso of Belloni, Chernozhukov, Hansen and Kozbur (2016) \doi{10.1080/07350015.2015.1102733}.
}
\section{Functions}{

The workhorse of this package is the \code{mlfitppml} function, which allows users to carry out
penalized HDFE-PPML estimation with a wide variety of options. The syntax is very simple, allowing
users to select a data frame with all the relevant variables and then select dependent, independent
and fixed effects variables by name or column number.

In addition, the internals \code{hdfeppml} (post-lasso regression), \code{penhdfeppml} (penalized
regression for a single lambda), \code{penhdfeppml_cluster} (plugin lasso), and \code{xvalidate} (cross-
validation) are made available on a stand-alone basis for advanced users.

The package also includes alternative versions of \code{mlfitppml}, \code{hdfeppml}, \code{penhdfeppml}
and \code{penhdfeppml_cluster}. These (\code{mlfitppml_int}, \code{hdfeppml_int}, \code{penhdfeppml_int}
and \code{penhdfeppml_cluster_int}) use an alternative syntax: users must provide the dependent variable
in a vector, the regressors in a matrix and the fixed effects in a list.

Finally, support for the iceberg lasso method in Breinlich, Corradi, Rocha, Ruta, Santos Silva,
and Zylkin (2021) is in development and can be accessed at its current stage via the \code{iceberg}
function.
}

\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tomzylkin/penppml}
  \item Report bugs at \url{https://github.com/tomzylkin/penppml/issues}
}

}
\author{
\strong{Maintainer}: Joao Cruz \email{jm01780@surrey.ac.uk}

Authors:
\itemize{
  \item Diego Ferreras Garrucho \email{d.ferreras-garrucho@lse.ac.uk}
  \item Tom Zylkin \email{tzylkin@richmond.edu}
}

}
\keyword{internal}
