% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regmest_regression.R
\name{regmest}
\alias{regmest}
\title{Compute (Adaptive) Elastic Net M-Estimates of Regression}
\usage{
regmest(
  x,
  y,
  alpha,
  nlambda = 50,
  lambda,
  lambda_min_ratio,
  scale,
  starting_points,
  penalty_loadings,
  intercept = TRUE,
  cc = 4.7,
  eps = 1e-06,
  explore_solutions = 10,
  explore_tol = 0.1,
  max_solutions = 10,
  comparison_tol = sqrt(eps),
  sparse = FALSE,
  ncores = 1,
  standardize = TRUE,
  algorithm_opts = mm_algorithm_options(),
  add_zero_based = TRUE,
  mscale_bdp = 0.25,
  mscale_opts = mscale_algorithm_options()
)
}
\arguments{
\item{x}{\code{n} by \code{p} matrix of numeric predictors.}

\item{y}{vector of response values of length \code{n}.
For binary classification, \code{y} should be a factor with 2 levels.}

\item{alpha}{elastic net penalty mixing parameter with \eqn{0 \le \alpha \le 1}. \code{alpha = 1} is the LASSO penalty,
and \code{alpha = 0} the Ridge penalty.}

\item{nlambda}{number of penalization levels.}

\item{lambda}{optional user-supplied sequence of penalization levels. If given and not \code{NULL}, \code{nlambda} and
\code{lambda_min_ratio} are ignored.}

\item{lambda_min_ratio}{Smallest value of the penalization level as a fraction of the largest level (i.e., the
smallest value for which all coefficients are zero). The default depends on the sample
size relative to the number of variables and \code{alpha}. If more observations than variables
are available, the default is \code{1e-3 * alpha}, otherwise \code{1e-2 * alpha}.}

\item{scale}{fixed scale of the residuals.}

\item{starting_points}{a list of staring points, created by \code{\link[=starting_point]{starting_point()}}. The starting points are shared
among all penalization levels.}

\item{penalty_loadings}{a vector of positive penalty loadings (a.k.a. weights) for different penalization of each
coefficient. Only allowed for \code{alpha} > 0.}

\item{intercept}{include an intercept in the model.}

\item{cc}{cutoff constant for Tukey's bisquare \eqn{\rho} function.}

\item{eps}{numerical tolerance.}

\item{explore_solutions}{number of solutions to compute up to the desired precision \code{eps}.}

\item{explore_tol}{numerical tolerance for exploring possible solutions. Should be (much) looser than \code{eps} to
be useful.}

\item{max_solutions}{only retain up to \code{max_solutions} unique solutions per penalization level.}

\item{comparison_tol}{numeric tolerance to determine if two solutions are equal. The comparison is first done
on the absolute difference in the value of the objective function at the solution
If this is less than \code{comparison_tol}, two solutions are deemed equal if the squared difference
of the intercepts is less than \code{comparison_tol} and the squared \eqn{L_2} norm of the
difference vector is less than \code{comparison_tol}.}

\item{sparse}{use sparse coefficient vectors.}

\item{ncores}{number of CPU cores to use in parallel. By default, only one CPU core is used. May not be supported
on your platform, in which case a warning is given.}

\item{standardize}{logical flag to standardize the \code{x} variables prior to fitting the M-estimates.
Coefficients are always returned on the original scale. This can fail for variables with a large
proportion of a single value (e.g., zero-inflated data). In this case, either compute with
\code{standardize = FALSE} or standardize the data manually.}

\item{algorithm_opts}{options for the MM algorithm to compute estimates. See \code{\link[=mm_algorithm_options]{mm_algorithm_options()}} for details.}

\item{add_zero_based}{also consider the 0-based regularization path in addition to the given starting points.}

\item{mscale_bdp, mscale_opts}{options for the M-scale estimate used to standardize the predictors
(if \code{standardize = TRUE}).}
}
\value{
a list-like object with the following items
\describe{
\item{\code{lambda}}{the sequence of penalization levels.}
\item{\code{scale}}{the used scale of the residuals.}
\item{\code{estimates}}{a list of estimates. Each estimate contains the following information:
\describe{
\item{\code{intercept}}{intercept estimate.}
\item{\code{beta}}{beta (slope) estimate.}
\item{\code{lambda}}{penalization level at which the estimate is computed.}
\item{\code{alpha}}{\emph{alpha} hyper-parameter at which the estimate is computed.}
\item{\code{objf_value}}{value of the objective function at the solution.}
\item{\code{statuscode}}{if \verb{> 0} the algorithm experienced issues when computing the estimate.}
\item{\code{status}}{optional status message from the algorithm.}
}
}
\item{\code{call}}{the original call.}
}
}
\description{
Compute elastic net M-estimates along a grid of penalization levels with optional
penalty loadings for adaptive elastic net.
}
\seealso{
\code{\link[=regmest_cv]{regmest_cv()}} for selecting hyper-parameters via cross-validation.

\code{\link[=coef.pense_fit]{coef.pense_fit()}} for extracting coefficient estimates.

\code{\link[=plot.pense_fit]{plot.pense_fit()}} for plotting the regularization path.

Other functions to compute robust estimates: 
\code{\link{pense}()}
}
\concept{functions to compute robust estimates}
