% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dend.R
\name{buildDend}
\alias{buildDend}
\title{Build the tree for the window of SNVs.}
\usage{
buildDend(snvWin, sep)
}
\arguments{
\item{snvWin}{A list contains these three components: (1) hapMat: the  data structure summerizing
the SNV window.
(2) focalSNV: the column number of the focal SNV at which to reconstruct the
perfect phylogeny.
(3) compat: the local vector of whether or not each SNV in the window
is compatible with the focal SNV.}

\item{sep}{A character string separator for concatenating haplotype labels in the
dendrogram if they are undistingushable in the window around the focal SNV
, see the arguments in \code{\link{reconstructPP}}.}
}
\value{
An object of class \code{phylo}.
}
\description{
This function builds the perfect phylogeny for the window of SNVs which is selected from function
\code{\link{selectWindow}}.
}
\details{
This function works in two stages. First, it orders the SNVs in the window, based on age
for compatible SNVs and proximity to the focal SNV for incompatible SNVs.
Then, it makes the perfect phylogeny for the ordered SNVs using recursive partitioning and records
the partitioning.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# First select a window of SNVs about a focal SNV.

SNV_win <- selectWindow(hapMat = ex_hapMatSmall_data,
                       focalSNV = 10, minWindow = 1)
                       
# Then, build the partitions for the selected window of SNVs.

dend <- buildDend(snvWin = SNV_win, sep = "-")                        

}

}
\seealso{
\code{\link{reconstructPP}}, \code{\link{orderSNVs}}, \code{\link{makeDend}}
}
\keyword{internal}
