% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_window.R
\name{selectWindow}
\alias{selectWindow}
\title{Select a window of SNVs about the focal SNV.}
\usage{
selectWindow(hapMat, focalSNV, minWindow)
}
\arguments{
\item{hapMat}{\code{hapMat} data object.}

\item{focalSNV}{The column number of the focal SNV in the \code{hapMat} data object.}

\item{minWindow}{Minimum window size of the SNV neighborhood.}
}
\description{
This internal function first identifies as many compatible SNVs as possible around the focal SNV. If the
neighborhood of compatible SNVs is smaller than a user-defined minimum number of SNVs, this function expands
the neighborhood by including incompatible SNVs in order of proximity to the focal SNV using the algorithm
of Mailund et al. (2006). Then the function subsets the columns of the \code{hapMat} data object according
to the resulting SNV window.
}
\examples{

\dontshow{
data(ex_hapMatSmall_data)

# Neighborhood of SNVs around the focal SNV.

nghborhood <- selectWindow(hapMat = ex_hapMatSmall_data, 
                           focalSNV = 10, 
                           minWindow = 1)
                                                          
}
 


}
\references{
Mailund, T., Besenbacher, S., & Schierup, M. H. (2006). Whole genome association mapping
             by incompatibilities and local perfect phylogenies. BMC Bioinformatics, 7(1), 454.
}
\seealso{
\code{\link{reconstructPP}}, \code{\link{findSNVs}}, \code{\link{subsetHapMat}}
}
\keyword{internal}
