% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_distribution.R
\name{check_distribution}
\alias{check_distribution}
\title{Classify the distribution of a model-family using machine learning}
\usage{
check_distribution(model)
}
\arguments{
\item{model}{Typically, a model (that should response to \code{residuals()}).
May also be a numeric vector.}
}
\description{
Choosing the right distributional family for regression models is essential
to get more accurate estimates and standard errors. This function may help to
check a models' distributional family and see if the model-family probably
should be reconsidered. Since it is difficult to exactly predict the correct
model family, consider this function as somewhat experimental.
}
\details{
This function uses an internal random forest model to classify the
distribution from a model-family. Currently, following distributions are
trained (i.e. results of \code{check_distribution()} may be one of the
following): \code{"bernoulli"}, \code{"beta"}, \code{"beta-binomial"}, \code{"binomial"},
\code{"cauchy"}, \code{"chi"}, \code{"exponential"}, \code{"F"}, \code{"gamma"}, \code{"half-cauchy"},
\code{"inverse-gamma"}, \code{"lognormal"}, \code{"normal"}, \code{"negative binomial"},
\code{"negative binomial (zero-inflated)"}, \code{"pareto"}, \code{"poisson"},
\code{"poisson (zero-inflated)"}, \code{"tweedie"}, \code{"uniform"} and \code{"weibull"}.
\cr \cr
Note the similarity between certain distributions according to shape, skewness,
etc. Thus, the predicted distribution may not be perfectly representing the
distributional family of the underlying fitted model, or the response value.
\cr \cr
There is a \code{plot()} method, which shows the probabilities of all predicted
distributions, however, only if the probability is greater than zero.
}
\note{
This function is somewhat experimental and might be improved in future
releases. The final decision on the model-family should also be based on
theoretical aspects and other information about the data and the model.
\cr \cr
There is also a
\href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method}
implemented in the
\href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
\dontshow{if (all(insight::check_if_installed(c("lme4", "parameters", "randomForest"), quietly = TRUE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(sleepstudy, package = "lme4")
model <<- lme4::lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
check_distribution(model)
\dontshow{\}) # examplesIf}
\dontshow{if (all(insight::check_if_installed(c("see", "patchwork", "randomForest"), quietly = TRUE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
plot(check_distribution(model))
\dontshow{\}) # examplesIf}
}
