% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadableTable.R
\name{downloadableTable}
\alias{downloadableTable}
\title{downloadableTable module server function}
\usage{
downloadableTable(
  id,
  logger,
  filenameroot,
  downloaddatafxns = list(),
  tabledata,
  selection = NULL,
  table_options = list()
)
}
\arguments{
\item{id}{the ID of the Module's UI element}

\item{logger}{logger to use}

\item{filenameroot}{the base text used for user-downloaded file - can be
either a character string or a reactive expression returning a character
string}

\item{downloaddatafxns}{a \strong{named} list of functions providing the data as
return values.  The names for the list should be the same names that were used
when the table UI was created.}

\item{tabledata}{function or reactive expression providing the table display
data as a return value. This function should require no input parameters.}

\item{selection}{function or reactive expression providing the row_ids of the
rows that should be selected}

\item{table_options}{optional table formatting parameters check \code{?DT::datatable} for options full list.
Also see example below to see how to pass options}
}
\value{
Reactive expression containing the currently selected rows in the
display table
}
\description{
Server-side function for the downloadableTableUI.  This is a custom
high-functionality table paired with a linked downloadFile
button.
}
\details{
Generated table can highly customized using function \code{?DT::datatable} same arguments
 except for `options` and `selection` parameters.

For `options` user can pass the same \code{?DT::datatable} options using the same names and
values one by one separated by comma.

For `selection` parameter it can be either a function or reactive expression providing the row_ids of the
rows that should be selected.

Also, user can apply the same provided \code{?DT::formatCurrency} columns formats on passed
dataset using format functions names as keys and their options as a list.
}
\section{Notes}{

 \itemize{
  \item When there are no rows to download in any of the linked downloaddatafxns
  the button will be hidden as there is nothing to download.
  \item \code{selection} parameter has different usage than DT::datatable \code{selection} option.
  See parameters usage section.
  \item DT::datatable options \code{editable}, \code{width} and \code{height} are not supported
}
}

\section{Shiny Usage}{

This function is not called directly by consumers - it is accessed in
server.R using the same id provided in \code{downloadableTableUI}:

\strong{\code{downloadableTable(id, logger, filenameroot,
downloaddatafxns, tabledata, rownames, caption, selection)}}

\emph{Note}: calling module server returns the reactive expression containing the
currently selected rows in the display table.
}

\examples{
if (interactive()) {
 library(shiny)
 library(periscope2)
 shinyApp(ui = fluidPage(fluidRow(column(width = 12,
   downloadableTableUI("object_id1",
                       downloadtypes = c("csv", "tsv"),
                       hovertext     = "Download the data here!",
                       contentHeight = "300px",
                       singleSelect  = FALSE)))),
   server = function(input, output) {
     mydataRowIds <- function(){
       rownames(head(mtcars))[c(2, 5)]
     }
     selectedrows <- downloadableTable(
       id               = "object_id1",
       logger           = "",
       filenameroot     = "mydownload1",
       downloaddatafxns = list(csv = reactiveVal(mtcars), tsv = reactiveVal(mtcars)),
       tabledata        = reactiveVal(mtcars),
       selection        = mydataRowIds,
       table_options    = list(rownames = TRUE,
                            caption  = "This is a great table!"))
     observeEvent(selectedrows(), {
       print(selectedrows())
     })})
}

}
\seealso{
\link[periscope2]{downloadableTableUI}

\link[periscope2]{downloadFileButton}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadablePlot}
}
