% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fibre.plot.R
\name{fibre.plot}
\alias{fibre.plot}
\title{\code{fibre.plot} (fibrously) plots a phylogeny}
\usage{
fibre.plot(
  tree,
  gif,
  focal,
  frames = 60,
  colours = colorRampPalette(c("blue", "black", "red")),
  f.colours = colorRampPalette(c("darkgreen", "lightgreen")),
  pca = NULL,
  clade.mat = NULL,
  delay = 0.2,
  side.tree = TRUE,
  width = 600,
  height = 600
)
}
\arguments{
\item{tree}{a phylogeny (of class phylo) you wish to plot}

\item{gif}{name of GIF you would like to create. This should *not*
including a folder name (this is due to the use of
\code{\link[animation]{saveGIF}}); "plot.gif" would be fine,
but "work/plot.gif" would not}

\item{focal}{species numbers or clade numbers to plot differently
(see examples). Note that specifying a clade will highlight the
clade *before* it arises; this is by design. If not specified
(the default) there will be no focal species; this is fine.}

\item{frames}{number of frames for animation; this will also
determine the time internals for the plot}

\item{colours}{a function that will return a colour ramp for use in
plotting of species on the fiber plot itself as well as the
standard phylogeny to the right (e.g., \code{\link{rainbow}})}

\item{f.colours}{as \code{colours} but for the \code{focal} species}

\item{pca}{PCA (of class \code{\link[stats]{prcomp}}) of
phylogenetic dissimilarity matrix; NULL calculates one, I
recommend you use the output from a previous run to speed
things up}

\item{clade.mat}{clade matrix (from
\code{\link[caper]{clade.matrix}}$clade.matrix) of phylogeny; NULL
calculates one, I recommend you use the output from a previous
run to speed things up}

\item{delay}{the delay between each slice's frame in the output
GIF; default 0.2 seconds}

\item{side.tree}{whether to plot a standard phylogeny to the right
of the plot to aid with interpretation (default: TRUE). You
almost certainly want this option}

\item{width}{width of animation}

\item{height}{height of animation}
}
\value{
The data that were plotted last, the PCA and clade.matrix
    to speed later plots, and the colours used.
}
\description{
\code{fibre.plot} (fibrously) plots a phylogeny
}
\details{
Probably best to just plot it out and see what happens, to
    be honest.
}
\note{
I would be grateful if you could cite the article this code
    was released in when using this code. I maintain this code in
    the package "willeerd" on GitHub. I give an example of how to
    install this code from there below. Updates will be released
    through that, and I welcome code improvements!
}
\examples{
\dontrun{
fibre.plot(rlineage(0.1,0), "Yule_fibre.gif")
}
}
\author{
Will Pearse
}
