% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{createTABLE}
\alias{createTABLE}
\title{Generate a postgreSQL CREATE TABLE statement, optionally execute the statement if con is not NULL.}
\usage{
createTABLE(
  name,
  columns,
  constraints = NULL,
  temporary = FALSE,
  if_not_exists = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "table_name" parameter for postgreSQL CREATE TABLE.}

\item{columns}{A named list, names are the SQL column names, values are strings with the SQL column data types, constraints, etc.}

\item{constraints}{A named list, names are the SQL constraint names, values are strings with the SQL constraint.}

\item{temporary}{TRUE/FALSE, if TRUE, adds "TEMPORARY" to postgreSQL CREATE TABLE statement.}

\item{if_not_exists}{TRUE/FALSE, if TRUE, adds "IF NOT EXISTS" to postgreSQL CREATE TABLE statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL CREATE TABLE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL CREATE TABLE statement, optionally execute the statement if con is not NULL.
}
\examples{
createTABLE(
name = "sample",
columns = list(col1 = "SERIAL NOT NULL", col2 = "INTEGER", col3 = "TEXT"),
constraints = list(sample_constraint = "UNIQUE(col3)")
)
}
