% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{createPROCEDURE}
\alias{createPROCEDURE}
\title{Generate a PostgreSQL CREATE PROCEDURE statement, optionally execute the statement if con is not NULL.}
\usage{
createPROCEDURE(
  name,
  args = NULL,
  or_replace = FALSE,
  language = "SQL",
  definition,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for PostgreSQL CREATE PROCEDURE.}

\item{args}{A named list, names are the argument names, values are strings with the argument data types.}

\item{or_replace}{TRUE/FALSE, if TRUE, adds "OR REPLACE" to PostgreSQL CREATE PROCEDURE statement.}

\item{language}{A string, the "language" parameter for PostgreSQL CREATE PROCEDURE.}

\item{definition}{A string, the "definition" parameter for PostgreSQL CREATE PROCEDURE.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL CREATE PROCEDURE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a PostgreSQL CREATE PROCEDURE statement, optionally execute the statement if con is not NULL.
}
\examples{
createPROCEDURE(
name = "sample",
args = list(a = "INTEGER", b = "TEXT"),
definition = "INSERT INTO tbl(col1, col2) VALUES (a, b);"
)
}
