#' This package contains a function to generates random samples from the Polya-Gamma 
#' distribution using an implementation of the algorithm described in J. Windle's PhD thesis. 
#' A frequent application of this distribution is in Bayesian analysis of logistic regression models.
#' 
#' The underlying implementation is in C.
#' 
#' For usage, see the examples in \code{\link{pgdraw}} and \code{\link{pgdraw.moments}}.
#' 
#' @title The pgdraw package
#' @docType package
#' @author Daniel Schmidt \email{daniel.schmidt@@monash.edu} 
#' 
#' Faculty of Information Technology, Monash University, Australia
#'
#' Enes Makalic \email{emakalic@@unimelb.edu.au}
#' 
#' Centre for Epidemiology and Biostatistics, The University of Melbourne, Australia
#' 
#' @note     To cite this package please reference: 
#'
#' Makalic, E. & Schmidt, D. F.
#' High-Dimensional Bayesian Regularised Regression with the BayesReg Package
#' arXiv:1611.06649 [stat.CO], 2016 \url{https://arxiv.org/pdf/1611.06649.pdf}
#' 
#' A MATLAB-compatible implementation of the sampler in this package can be obtained from:
#' 
#' \url{http://dschmidt.org/?page_id=189}
#'
#' @keywords distribution, Polya-Gamma
#' @seealso \code{\link{pgdraw}}, \code{\link{pgdraw.moments}}
#' @import Rcpp 
#' @importFrom Rcpp evalCpp
#' @useDynLib pgdraw .registration=TRUE
#' @name pgdraw-package
#' @references 
#' 
#'  Jesse Bennett Windle
#'  Forecasting High-Dimensional, Time-Varying Variance-Covariance Matrices
#'  with High-Frequency Data and Sampling Polya-Gamma Random Variates for
#'  Posterior Distributions Derived from Logistic Likelihoods  
#'  PhD Thesis, 2013 
#'  
#'  Bayesian Inference for Logistic Models Using Polya-Gamma Latent Variables
#'  Nicholas G. Polson, James G. Scott and Jesse Windle
#'  Journal of the American Statistical Association
#'  Vol. 108, No. 504, pp. 1339--1349, 2013
#'  
#'  Chung, Y.: Simulation of truncated gamma variables 
#'  Korean Journal of Computational & Applied Mathematics, 1998, 5, 601-610
#' 
# @exportPattern "^[[:alpha:]]+"
NULL