### R code from vignette source 'pgs_user.Rnw'
### Encoding: UTF-8

###################################################
### code chunk number 1: load:lib
###################################################
library(pgs)


###################################################
### code chunk number 2: def:plat
###################################################
plat=PPHexLat2(delta=1,n=4)


###################################################
### code chunk number 3: print:lat
###################################################
print(plat)


###################################################
### code chunk number 4: plot:plat:1
###################################################
pdf("plat.pdf",onefile=FALSE,height=1,width=1,pointsize=11)
par(mar=c(1,1,1,1))
par(xaxt="n",yaxt="n")


###################################################
### code chunk number 5: plot:plat:2
###################################################
plot(plat,xlim=c(0,3),ylim=c(0,3),pch="+",cex=0.3)


###################################################
### code chunk number 6: plot:plat:3
###################################################
dev.off()


###################################################
### code chunk number 7: def:p3lat
###################################################
p3lat=PPRectLat3(dx=1,dy=1,dz=1,n=4)


###################################################
### code chunk number 8: ex:figlat
###################################################
plat=FigLat(2,HexLat2(sqrt(3)/2),PP2(n=4,h=1/5))


###################################################
### code chunk number 9: area:mse:approx
###################################################
area.mse(plat,B=1,L=3)


###################################################
### code chunk number 10: design
###################################################
u = latscale(PPHexLat2(n=4),A=1,shape=5,CE.n=0.05,upper=2)
u


###################################################
### code chunk number 11: counts
###################################################
counts = c(5,3,1,4,1,3,4,2,4,5)


###################################################
### code chunk number 12: area:pred
###################################################
areaPred = counts/(4*plat@vlat@det)
areaPred


###################################################
### code chunk number 13: var
###################################################
var(areaPred)


###################################################
### code chunk number 14: perimeter
###################################################
B = 5*sqrt(mean(areaPred))
B


###################################################
### code chunk number 15: area:mse
###################################################
area.mse(plat, B)


###################################################
### code chunk number 16: pgs_user.Rnw:378-379
###################################################
var(areaPred)-area.mse(plat, B)


###################################################
### code chunk number 17: pplat
###################################################
pplat=PPRectLat2(1,1,5,0.4)


###################################################
### code chunk number 18: data
###################################################
load("italy_pp_counts.RData")
write.table(pp.counts,row.names=FALSE,col.names=FALSE)


###################################################
### code chunk number 19: figlatdata
###################################################
ppldata=FigLatData(pplat,pp.counts)


###################################################
### code chunk number 20: area:mse:est
###################################################
area.mse.est(ppldata,mse.only=FALSE,iso=TRUE)


###################################################
### code chunk number 21: stretch
###################################################
area.mse.est(ppldata,mse.only=FALSE,iso=FALSE)


