% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_peripheral_compartment}
\alias{add_peripheral_compartment}
\title{add_peripheral_compartment}
\usage{
add_peripheral_compartment(model)
}
\arguments{
\item{model}{(Model) Pharmpy model}
}
\value{
(Model) Reference to same model
}
\description{
Add a peripheral distribution compartment to model

The rate of flow from the central to the peripheral compartment
will be parameterized as QPn / VC where VC is the volume of the central compartment.
The rate of flow from the peripheral to the central compartment
will be parameterized as QPn / VPn where VPn is the volumne of the added peripheral
compartment.

Initial estimates:

==  ===================================================
n
==  ===================================================
1   :math:\verb{\{CL\} = \{CL'\}}, :math:\verb{\{VC\} = \{VC'\}},
:math:\verb{\{QP1\} = \{CL'\}} and :math:\verb{\{VP1\} = \{VC'\} * 0.05}
2   :math:\verb{\{QP1\} = \{QP1' / 2\}}, :math:\verb{\{VP1\} = \{VP1'\}},
:math:\verb{\{QP2\} = \{QP1' / 2\}} and :math:\verb{\{VP2\} = \{VP1'\}}
==  ===================================================
}
\examples{
\dontrun{
model <- load_example_model("pheno")
add_peripheral_compartment(model)
model$statements$ode_system
}
}
\seealso{
set_peripheral_compartment

remove_peripheral_compartment
}
