% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_population_parameter}
\alias{add_population_parameter}
\title{add_population_parameter}
\usage{
add_population_parameter(
  model,
  name,
  init,
  lower = NULL,
  upper = NULL,
  fix = FALSE
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{name}{(str) Name of the new parameter}

\item{init}{(numeric) Initial estimate of the new parameter}

\item{lower}{(numeric) Lower bound of the new parameter}

\item{upper}{(numeric) Upper bound of the new parameter}

\item{fix}{(logical) Should the new parameter be fixed?}
}
\value{
(Model) Reference to the same model object
}
\description{
Add a new population parameter to the model
}
\examples{
\dontrun{
model <- load_example_model("pheno")
add_population_parameter(model, 'POP_KA', 2)
model$parameters
}

}
