% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_iovsearch}
\alias{run_iovsearch}
\title{run_iovsearch}
\usage{
run_iovsearch(
  column = "OCC",
  list_of_parameters = NULL,
  rank_type = "bic",
  cutoff = NULL,
  distribution = "same-as-iiv",
  model = NULL
)
}
\arguments{
\item{column}{(str) Name of column in dataset to use as occasion column (default is 'OCC')}

\item{list_of_parameters}{(vector) List of parameters to test IOV on, if none all parameters with IIV will be tested (default)}

\item{rank_type}{(str) Which ranking type should be used (OFV, AIC, BIC). Default is BIC}

\item{cutoff}{(NULL or numeric) Cutoff for which value of the ranking type that is considered significant. Default
is NULL (all models will be ranked)}

\item{distribution}{(str) Which distribution added IOVs should have (default is same-as-iiv)}

\item{model}{(Model) Pharmpy model}
}
\value{
(IOVSearchResults) IOVSearch tool result object
}
\description{
Run IOVsearch tool. For more details, see :ref:\code{iovsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
run_iovsearch('OCC', model=model)
}

}
