% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{has_random_effect}
\alias{has_random_effect}
\title{has_random_effect}
\usage{
has_random_effect(model, parameter, level = "all")
}
\arguments{
\item{model}{(Model) Input Pharmpy model}

\item{parameter}{(str) Input parameter}

\item{level}{(str) The variability level to look for: 'iiv', 'iov', or 'all' (default)}
}
\value{
(logical) Whether the given parameter has a random effect
}
\description{
Decides whether the given parameter of a :class:\code{pharmpy.model} has a
random effect.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
has_random_effect(model, 'S1')
has_random_effect(model, 'CL', 'iiv')
has_random_effect(model, 'CL', 'iov')
}
}
\seealso{
get_individual_parameters

get_rv_parameters
}
