% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ph_crocs}
\alias{ph_crocs}
\title{Data from: The utility of cranial ontogeny for phylogenetic inference: a case study in crocodylians using geometric morphometrics}
\format{
\subsection{\code{ph_crocs}}{

A data frame of Procrustes superimposed shape data with 183 rows and 236 columns:
\describe{
\item{Biosample}{Biosample}
\item{Species}{Species}
...
}
}
}
\source{
Downloaded from
\if{html}{\out{<\doi{dx.doi.org/10.5061/dryad.14fn1}>}}
}
\usage{
ph_crocs
}
\description{
Abstract: The degree to which the ontogeny of organisms could facilitate our understanding of phylogenetic relationships
has long been a subject of contention in evolutionary biology. The famed notion that ‘ontogeny recapitulates phylogeny’ has
been largely discredited, but there remains an expectation that closely related organisms undergo similar morphological
transformations throughout ontogeny. To test this assumption, we used three-dimensional geometric morphometric methods to
characterize the cranial morphology of 10 extant crocodylian species and construct allometric trajectories that model the
post-natal ontogenetic shape changes. Using time-calibrated molecular and morphological trees, we employed a suite of
comparative phylogenetic methods to assess the extent of phylogenetic signal in these trajectories. All analyses largely
demonstrated a lack of significant phylogenetic signal, indicating that ontogenetic shape changes contain little phylogenetic
information. Notably, some Mantel tests yielded marginally significant results when analysed with the morphological tree,
which suggest that the underlying signal in these trajectories is correlated with similarities in the adult cranial morphology.
However, despite these instances, all other analyses, including more powerful tests for phylogenetic signal, recovered
statistical and visual evidence against the assumption that similarities in ontogenetic shape changes are commensurate with
phylogenetic relatedness and thus bring into question the efficacy of using allometric trajectories for phylogenetic inference.
}
\keyword{datasets}
