% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GOF.R
\name{get_GOF}
\alias{get_GOF}
\alias{get_GOF.fFITs}
\title{get_GOF}
\usage{
get_GOF(fit)

get_GOF.fFITs(fFITs)
}
\arguments{
\item{fit}{Object returned by \code{curvefits}.}

\item{fFITs}{\code{fFITs} object returned by \code{\link[=curvefit]{curvefit()}}.}
}
\value{
\itemize{
\item \code{meth}: The name of fine curve fitting method
\item \code{RMSE}: Root Mean Square Error
\item \code{NSE} : Nash-Sutcliffe model efficiency coefficient
\item \code{R}   : Pearson-Correlation
\item \code{pvalue}: pvalue of \code{R}
\item \code{n}   : The number of observations
}
}
\description{
Goodness-of-fitting (GOF) of fine curve fitting results.
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c( mn  = 0.1, mx  = 0.7, sos = 50, rsp = 0.1, eos = 250, rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)
methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fFITs <- curvefit(y, t, tout, methods)
# multiple years
fits  <- list(`2001` = fFITs, `2002` = fFITs)

l_param   <- get_param(fits)
d_GOF     <- get_GOF(fits)
d_fitting <- get_fitting(fits)
l_pheno   <- get_pheno(fits, "AG", IsPlot=TRUE)
}
\references{
\enumerate{
\item https://en.wikipedia.org/wiki/Nash-Sutcliffe_model_efficiency_coefficient \cr
\item https://en.wikipedia.org/wiki/Pearson_correlation_coefficient
}
}
\seealso{
\code{\link[=curvefit]{curvefit()}}
}
