% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot_errbar.R
\name{plot_errbar}
\alias{plot_errbar}
\title{Plot a xy graph with error bar on x and/or y}
\usage{
plot_errbar(..., errbar.x = NULL, errbar.y = NULL, errbar.x.plus = NULL,
  errbar.x.minus = NULL, errbar.y.plus = NULL, errbar.y.minus = NULL,
  x.plus = NULL, x.minus = NULL, y.plus = NULL, y.minus = NULL,
  errbar.tick = 1/50, errbar.lwd = par("lwd"), errbar.lty = par("lty"),
  errbar.col = par("fg"), errbar.y.polygon = FALSE,
  errbar.y.polygon.list = list(NULL), add = FALSE)
}
\arguments{
\item{...}{Parameters for plot() such as main= or ylim=}

\item{errbar.x}{The length of error bars for x. Recycled if necessary.}

\item{errbar.y}{The length of error bars for y. Recycled if necessary.}

\item{errbar.x.plus}{The length of positive error bars for x. Recycled if necessary.}

\item{errbar.x.minus}{The length of negative error bars for x. Recycled if necessary.}

\item{errbar.y.plus}{The length of positive error bars for y. Recycled if necessary.}

\item{errbar.y.minus}{The length of negative error bars for y. Recycled if necessary.}

\item{x.plus}{The absolut position of the positive error bar for x. Recycled if necessary.}

\item{x.minus}{The absolut position of the negative error bar for x. Recycled if necessary.}

\item{y.plus}{The absolut position of the positive error bar for y. Recycled if necessary.}

\item{y.minus}{The absolut position of the nagative error bar for y. Recycled if necessary.}

\item{errbar.tick}{Size of small ticks at the end of error bars defined as a proportion of total width or height graph size.}

\item{errbar.lwd}{Error bar line width, see par("lwd")}

\item{errbar.lty}{Error bar line type, see par("lwd")}

\item{errbar.col}{Error bar line color, see par("col")}

\item{errbar.y.polygon}{If true, the errors are shown as a filed polygon.}

\item{errbar.y.polygon.list}{List of parameters to be used for polygon.}

\item{add}{If true, add the graph to the previous one.}
}
\value{
Nothing
}
\description{
To plot data, just use it as a normal plot but add the errbar.x
and errbar.y values or errbar.x.minus, errbar.x.plus if bars for x axis are
asymetric and errbar.y.minus, errbar.y.plus if bars for y axis are
asymetric. Use x.plus, x.minus, y.plus and y.minus to set absolut limits for
error bars. Note that x.plus and x.minus have priority over errbar.x, errbar.x.minus and
errbar.x.plus and that y.plus and y.minus have priority over errbar.y, errbar.y.minus and
errbar.y.plus.
The parameter errbar.y.polygon=TRUE permits to define error as an envolop for y axis.
}
\details{
plot_errbar plot a xy graph with error bar on x and/or y
}
\examples{
plot_errbar(1:100, rnorm(100, 1, 2),
		xlab="axe x", ylab="axe y", bty="n", xlim=c(1,100),
		errbar.x=2, errbar.y=rnorm(100, 1, 0.1))
x <- 1:100
plot_errbar(x=1:100, rnorm(100, 1, 2),
               	xlab="axe x", ylab="axe y", bty="n", xlim=c(1,100),
            		x.minus=x-2, x.plus=x+2)
x <- (1:200)/10
y <- sin(x)
plot_errbar(x=x, y=y, xlab="axe x", ylab="axe y", bty="n", xlim=c(1,20),
     y.minus=y-1, y.plus=y+1, ylim=c(-3, 3), type="l",
		errbar.y.polygon=TRUE,
		errbar.y.polygon.list=list(border=NA, col=rgb(0, 0, 0, 0.5)))
}
\author{
Marc Girondot
}

