#' print.phenology prints the information from a result x.
#' @title Print the result information from a result x.
#' @author Marc Girondot
#' @return None
#' @param x A result file generated by fit_phenology
#' @param ... Not used
#' @description The function print.phenology displays from a result.
#' @examples
#' library(phenology)
#' # Read a file with data
#' \dontrun{
#' Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
#' }
#' data(Gratiot)
#' # Generate a formatted list nammed data_Gratiot 
#' data_Gratiot<-add_phenology(Gratiot, name="Complete", 
#' 		reference=as.Date("2001-01-01"), format="%d/%m/%Y")
#' # Generate initial points for the optimisation
#' parg<-par_init(data_Gratiot, fixed.parameters=NULL)
#' # Run the optimisation
#' \dontrun{
#' result_Gratiot<-fit_phenology(data=data_Gratiot, 
#' 		fitted.parameters=parg, fixed.parameters=NULL)
#' }
#' data(result_Gratiot)
#' # Show the result
#' result_Gratiot
#' @method print phenology
#' @export


print.phenology <- function(x, ...) {

  cat(paste("Number of timeseries: ", length(x$data), "\n", sep=""))
  for (i in 1:length(x$data)) {
    cat(paste(names(x$data[i]), "\n", sep=""))
  }
  cat(paste("Date uncertainty management: ", x$method_incertitude, "\n", sep=""))
  cat(paste("Managment of zero counts: ", x$zero_counts, "\n", sep=""))
  cat("Fitted parameters:\n")
  for (i in 1:length(x$par)) {
    cat(paste(names(x$par[i]), "=", x$par[i], " SE ", x$se[i], "\n", sep=""))
  }
  if (length(x$fixed.parameters)>0) {
    cat("Fixed parameters:\n")
    for (i in 1:length(x$fixed.parameters)) {
      cat(paste(names(x$fixed.parameters[i]), "=", x$fixed.parameters[i], "\n", sep=""))
    }
  }
  cat(paste("Ln L: ", x$value, "\n", sep=""))
  cat(paste("Parameter number: ", length(x$par), "\n", sep=""))
  cat(paste("AIC: ", 2*x$value+2*length(x$par), "\n", sep=""))

}
