% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_simulate.R
\name{Tagloss_simulate}
\alias{Tagloss_simulate}
\title{Return a list with the number of days different kinds of individuals are seen.}
\usage{
Tagloss_simulate(n = 500, par, pobservation = c(rep(0.05, 70), 0.01),
  LengthObservation = c(min = 0, max = 9), dailysurvival = 0.999,
  model = "12", model_before = NULL, model_after = NULL,
  progressbar = TRUE)
}
\arguments{
\item{n}{Number of individuals to simulate}

\item{par}{Set of parameters}

\item{pobservation}{Probability of daily observation}

\item{LengthObservation}{The log of number of days of observations is a random number between min and max}

\item{dailysurvival}{Daily probability of survival}

\item{model}{Must be "12" or "LR"}

\item{model_before}{Transformation of parameters before to use Tagloss_model()}

\item{model_after}{Transformation of parameters after to use Tagloss_model()}

\item{progressbar}{Is a progressbar should be shown?}
}
\value{
Return a list with the number of days different kinds of individuals are seen.
}
\description{
Generate data with known features.\cr
  model_before is applied to par parameter.\cr
  model_after is applied after par is separated in p1, p2, pL1, pL2, pR1 and pR2 parameters.\cr
pobservation can be a vector of daily probabilities to be captured. The last value is repeated 
if necessary.\cr
The maximum number of days of observation is exp(LengthObservation["max"]).\cr
If model="12" then par must have _1 and _2 parameters.\cr
if model="LR" then par must have _L2, _L1, _R2, R1 parameters.\cr
}
\details{
Tagloss_simulate returns a list with the number of days different kinds of individuals are seen.
}
\examples{
library(phenology)
\dontrun{
# Example
par <- structure(c(49.5658922243074, 808.136085362158, 106.283783786853, 
5.22150592456511, 8.00608716525864, 8.32718202233396, 150.612916258503, 
715.865805125223, 2242.06574225966, 119.212383120678, 10.1860735529433, 
7.14231725937626), .Names = c("D1_2", "D2D1_2", "D3D2_2", "A_2", 
"B_2", "C_2", "D1_1", "D2D1_1", "D3D2_1", "A_1", "B_1", "C_1"))
cmr <- Tagloss_simulate(n=500, 
                        par=par, model="12")
cmr_f <- Tagloss_format(cmr, model="12")
}
}
\seealso{
Other Model of Tag-loss: \code{\link{Tagloss_LengthObs}},
  \code{\link{Tagloss_L}}, \code{\link{Tagloss_daymax}},
  \code{\link{Tagloss_fit}}, \code{\link{Tagloss_format}},
  \code{\link{Tagloss_model}},
  \code{\link{logLik.Tagloss}}, \code{\link{plot.Tagloss}}
}
\author{
Marc Girondot
}
\concept{Model of Tag-loss}
