% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_parameters.R
\name{adapt_parameters}
\alias{adapt_parameters}
\title{Extract the parameters from a set of parameters to be used with another dataset.}
\usage{
adapt_parameters(
  data = stop("Datasets is mandatory for this function"),
  parameters = stop("Set of parameters is mandatory for this function")
)
}
\arguments{
\item{data}{A dataset of counts}

\item{parameters}{A set of parameters}
}
\value{
Return the set of parameters
}
\description{
The function "adapt_parameters" extracts the set of parameters to be used with a subset of data. All the uncessary parameters are removed. It can be used when a set of beaches are fitted first and after only one of these beaches is fitted again.
}
\details{
adapt_parameters get the fitted parameters from a result object.
}
\examples{
library(phenology)
# Read a file with data
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
refdate <- as.Date("2001-01-01")
data_Gratiot<-add_phenology(Gratiot, name="Complete", 
		reference=refdate, format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, fixed.parameters=NULL)
# Add unnecessary parameters to parg
parg <- c(parg, Max_dummybeach=2, Peak_dummybeach=123)
# Extract the fitted parameters
parg1<-adapt_parameters(data=data_Gratiot, parameters=parg)
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot.phenology}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{print.phenology}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{result_Gratiot_mcmc}},
\code{\link{result_Gratiot}},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()},
\code{\link{summary.phenology}()}
}
\author{
Marc Girondot
}
\concept{Phenology model}
