% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-ooss-file.r
\name{read_oo_ssirrad}
\alias{read_oo_ssirrad}
\alias{read_oo_ssdata}
\title{Read File Saved by Ocean Optics' SpectraSuite.}
\usage{
read_oo_ssirrad(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale())

read_oo_ssdata(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale())
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is by default read from the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
A source_spct object.

A raw_spct object.
}
\description{
Reads and parses the header of a processed data file as output by
SpectraSuite to extract the whole header remark field. The time field is
retrieved and decoded.
}
\references{
\url{http://www.r4photobiology.info} \url{http://oceanoptics.com/}
}
\keyword{misc}
