% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-tuv-file.r
\name{read_tuv_usrout}
\alias{read_tuv_usrout}
\alias{read_tuv_usrout2mspct}
\title{Read TUV output file.}
\usage{
read_tuv_usrout(file, ozone.du = NULL, date = lubridate::today(),
  geocode = NULL, label = NULL, tz = NULL,
  locale = readr::default_locale())

read_tuv_usrout2mspct(file, ozone.du = NULL, date = lubridate::today(),
  geocode = NULL, label = NULL, tz = NULL,
  locale = readr::default_locale())
}
\arguments{
\item{file}{character string}

\item{ozone.du}{numeric Ozone column in Dobson units.}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is by default read from the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
a source_spct object obtained by 'melting' the TUV file, and adding a
  factor \code{spct.idx}, and variables \code{zenith.angle} and \code{date}.
}
\description{
Reads and parses the header of a text file output by the TUV program to
extract the header and spectral data. The time field is converted to a date.
}
\note{
The ozone column value used in the simulation cannot be retrieved from
the file. Tested only with TUV version 5.0.
}
\references{
\url{http://www.r4photobiology.info}
  \url{https://www2.acom.ucar.edu/modeling/tuv-download}
}
\keyword{misc}
