% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-licor-txt.r
\name{read_li180_txt}
\alias{read_li180_txt}
\alias{read_m_li180_txt}
\title{Read '.TXT' File(s) Saved by LI-COR's LI-180 spectroradiometer.}
\usage{
read_li180_txt(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  s.qty = "s.e.irrad"
)

read_m_li180_txt(
  files,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = Sys.timezone(),
  locale = readr::default_locale(),
  s.qty = NULL
)
}
\arguments{
\item{file}{Path to file as a character string.}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the
file header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{s.qty}{character The name of the spectral quantity to be read. One of
"s.e.irrad" or "s.q.irrad".}

\item{files}{A list or vector of character strings.}
}
\value{
\code{read_licor_espd()} returns a \code{source_spct} object with
  \code{time.unit} attribute set to \code{"second"} and \code{when.measured}
  attribute set to the date-time extracted from the file header, or supplied
  by the user. Spectrometer model, serial number and integration time are
  stored in attributes. The whole file header is saved as a \code{comment}
  while the footer is discarded.

Function \code{read_m_licor_espd()} returns a source_mspct object
  containing one spectrum per file read.
}
\description{
Reads and parses the header of a data file as output by the LI-180
spectrometer (not to be confused with the LI-1800 spectrometer released in
the 1980's by LI-COR) to extract the whole header remark field and also
decode whether data is in photon or energy based units. This is a new
instrument released in year 2020.
}
\details{
Function \code{read_m_licor_espd()} calls \code{red_licor_espd()} 
  for each file in \code{files}. See \code{\link{read.table}} for
  a description of valid arguments for \code{files}.
}
\note{
The LI-180 spectroradiometer stores little information of the
  instrument and settings, possibly because they cannot be altered by the
  user or configured. The length of the file header does not seem to be
  fixed, so the start of the spectral data is detected by searching for
  "380nm".
}
\examples{

  file.name <- 
    system.file("extdata", "LI-180-irradiance.txt", 
                package = "photobiologyInOut", mustWork = TRUE)
                
  licor180.spct <- read_li180_txt(file = file.name)
  
  licor180.spct
  getWhenMeasured(licor180.spct)
  getWhatMeasured(licor180.spct)
  cat(comment(licor180.spct))
  
}
\references{
LI-COR Biosciences, Environmental.
}
