## ------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=8, fig.height=4)

## ------------------------------------------------------------------------
library(photobiology)
library(photobiologyWavebands)
library(photobiologyLEDs)

## ------------------------------------------------------------------------
names(leds.mspct)

## ------------------------------------------------------------------------
leds.mspct$UV395

## ------------------------------------------------------------------------
leds.mspct[["UV395"]]

## ------------------------------------------------------------------------
leds.mspct["UV395"]

## ------------------------------------------------------------------------
leds.mspct[norlux]

## ------------------------------------------------------------------------
leds.mspct[grep("QDDH", names(leds.mspct))]

## ------------------------------------------------------------------------
my.spct <- fscale(leds.mspct$UV395,
                  range = c(315, 400),
                  e_irrad,
                  target = 10
                  )
e_irrad(my.spct, waveband(c(315,400)))

## ------------------------------------------------------------------------
getScaled(my.spct)
setScaled(my.spct)
getScaled(my.spct)

## ------------------------------------------------------------------------
my.UV395 <- leds.mspct$UV395
setNormalized(my.UV395)
e_irrad(my.UV395)

## ------------------------------------------------------------------------
q_ratio(leds.mspct$UV395, UVB(), UVA())

## ------------------------------------------------------------------------
head(as.data.frame(leds.mspct$UV395))

## ------------------------------------------------------------------------
attach(leds.mspct)
q_ratio(UV395, UVB(), UVA())
detach(leds.mspct)

## ------------------------------------------------------------------------
attach(leds.mspct)
with(UV395, max(w.length))
detach(leds.mspct)

## ------------------------------------------------------------------------
with(leds.mspct, q_ratio(UV395, UVB(), UVA()))

