% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phy-reaction-rates.R
\name{Phy_reaction_rates}
\alias{Phy_reaction_rates}
\title{Phytochrome reaction rates}
\usage{
Phy_reaction_rates(w.length, s.irrad, unit.in = "energy",
  check.spectrum = TRUE, use.cached.mult = FALSE)
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}

\item{s.irrad}{numeric array of spectral (energy) irradiances (W m-2 nm-1) or
(mol s-1 m-2)}

\item{unit.in}{character string with allowed values "energy", and "photon",
or its alias "quantum"}

\item{check.spectrum}{logical indicating whether to sanity check input data,
default is TRUE}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}
}
\value{
a list of three numeric values giving the photoconversion rate (nu)
  and reaction rates (k1, k2).
}
\description{
Rate constants k1 Pr -> Pfr; k2 Pfr -> Pr; photoconversion rate nu = k1 + k2
for Type I Phytochrome.
}
\examples{
library(photobiology)
trimmed.sun.spct <- trim_wl(sun.spct, range = c(300, 770))
with(trimmed.sun.spct, Phy_reaction_rates(w.length, s.e.irrad))

}
\references{
Hayward, P. M. (1984) Determination of phytochrome parameters
from radiation measurements. In Techniques in Photomorphogenesis, H. Smith
and M. G. Holmes (eds). Academic Press, London, pp. 159-173. ISBN
0-12-652990-6.

Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\href{http://dx.doi.org/10.1007/978-94-011-1884-2_10}{DOI
10.1007/978-94-011-1884-2_10}
}
\seealso{
\code{\link[photobiology]{photon_ratio}} and
  \code{\link[photobiology]{energy_ratio}}
}

